/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.table.MapTableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;

public class MyErrorTableFunction
implements TableFunction {
    private final String TBL_PARAM = "DATA";
    private final String N_PARAM = "N";

    public List<ParameterSpecification> getArgumentsSpecifications() {
        return Arrays.asList(TableParameterSpecification.builder().name("DATA").rowSemantics().passThroughColumns().build(), ScalarParameterSpecification.builder().name("N").type(Type.INT32).build());
    }

    public TableFunctionAnalysis analyze(Map<String, Argument> arguments) throws UDFException {
        ScalarArgument n = (ScalarArgument)arguments.get("N");
        int nValue = (Integer)n.getValue();
        if (nValue == 0) {
            return TableFunctionAnalysis.builder().properColumnSchema(DescribedSchema.builder().addField("proper_column", Type.INT32).build()).handle((TableFunctionHandle)new MapTableFunctionHandle()).build();
        }
        if (nValue == 1) {
            return TableFunctionAnalysis.builder().properColumnSchema(DescribedSchema.builder().addField("proper_column", Type.INT32).build()).requiredColumns("DATA", Collections.emptyList()).handle((TableFunctionHandle)new MapTableFunctionHandle()).build();
        }
        if (nValue == 2) {
            return TableFunctionAnalysis.builder().properColumnSchema(DescribedSchema.builder().addField("proper_column", Type.INT32).build()).requiredColumns("DATA", Collections.singletonList(-1)).handle((TableFunctionHandle)new MapTableFunctionHandle()).build();
        }
        if (nValue == 3) {
            return TableFunctionAnalysis.builder().properColumnSchema(DescribedSchema.builder().addField("proper_column", Type.INT32).build()).requiredColumns("DATA", IntStream.range(0, 11).boxed().collect(Collectors.toList())).handle((TableFunctionHandle)new MapTableFunctionHandle()).build();
        }
        if (nValue == 4) {
            return TableFunctionAnalysis.builder().properColumnSchema(DescribedSchema.builder().addField("proper_column", Type.INT32).build()).requiredColumns("TIMECHO", Collections.singletonList(1)).handle((TableFunctionHandle)new MapTableFunctionHandle()).build();
        }
        throw new UDFArgumentNotValidException("unexpected argument value");
    }

    public TableFunctionHandle createTableFunctionHandle() {
        return new MapTableFunctionHandle();
    }

    public TableFunctionProcessorProvider getProcessorProvider(TableFunctionHandle tableFunctionHandle) {
        return new TableFunctionProcessorProvider(){

            public TableFunctionDataProcessor getDataProcessor() {
                return (input, properColumnBuilders, passThroughIndexBuilder) -> {};
            }
        };
    }
}

