/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"locate", "instr"}, parameter="(String str1, String str2, Integer pos)", descriptions={"- Return \"\" if any of arguments is NULL'", "- Return 0 if not found'", "- Return the position of the first occurrence of 'str1' in 'str2' after position 'pos'."}, examples={"locate('app', 'apple') = 1", "locate('app', 'appapp', 2) = 4"})
public class LocateFunction
implements ValueParser {
    private ValueParser stringParser1;
    private ValueParser stringParser2;
    private ValueParser startPositionParser;

    public LocateFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser1 = OperatorTools.buildParser((Expression)expressions.get(0));
        this.stringParser2 = OperatorTools.buildParser((Expression)expressions.get(1));
        if (expressions.size() == 3) {
            this.startPositionParser = OperatorTools.buildParser((Expression)expressions.get(2));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj1 = this.stringParser1.parse(sourceData, rowIndex, context);
        Object stringObj2 = this.stringParser2.parse(sourceData, rowIndex, context);
        if (stringObj1 == null || stringObj2 == null) {
            return null;
        }
        String str1 = OperatorTools.parseString(stringObj1);
        String str2 = OperatorTools.parseString(stringObj2);
        if (this.startPositionParser != null) {
            Object startPositionObj = this.startPositionParser.parse(sourceData, rowIndex, context);
            if (startPositionObj == null) {
                return null;
            }
            int startPosition = OperatorTools.parseBigDecimal(startPositionObj).intValue();
            return str2.indexOf(str1, startPosition - 1) + 1;
        }
        return str2.indexOf(str1) + 1;
    }
}

