/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.ParquetInputByteArray;
import org.apache.inlong.sdk.transform.decode.ParquetSourceData;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.decode.TransformException;
import org.apache.inlong.sdk.transform.pojo.ParquetSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetSourceDecoder
extends SourceDecoder<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetSourceDecoder.class);
    protected ParquetSourceInfo sourceInfo;
    private Charset srcCharset = Charset.defaultCharset();
    private MessageType schema;
    private String childMessagePath;
    private String rootMessageLabel;

    public ParquetSourceDecoder(ParquetSourceInfo sourceInfo) {
        try {
            this.sourceInfo = sourceInfo;
            if (!StringUtils.isBlank((CharSequence)sourceInfo.getCharset())) {
                this.srcCharset = Charset.forName(sourceInfo.getCharset());
            }
            this.schema = MessageTypeParser.parseMessageType((String)sourceInfo.getParquetSchema());
            this.childMessagePath = sourceInfo.getChildMessagePath();
            this.rootMessageLabel = sourceInfo.getRootMessageLabel();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new TransformException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        try {
            ParquetInputByteArray inputFile = new ParquetInputByteArray(srcBytes);
            try (ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);){
                ParquetMetadata footer = reader.getFooter();
                MessageType schema = footer.getFileMetaData().getSchema();
                block14: while (true) {
                    PageReadStore pages;
                    if ((pages = reader.readNextRowGroup()) == null) return null;
                    long rows = pages.getRowCount();
                    ColumnIOFactory factory = new ColumnIOFactory();
                    MessageColumnIO columnIO = factory.getColumnIO(schema);
                    GroupRecordConverter recordMaterializer = new GroupRecordConverter(schema);
                    RecordReader recordReader = columnIO.getRecordReader(pages, (RecordMaterializer)recordMaterializer);
                    int i = 0;
                    while (true) {
                        if ((long)i >= rows) continue block14;
                        Group group = (Group)recordReader.read();
                        if (group != null) {
                            ParquetSourceData parquetSourceData = new ParquetSourceData(group, this.childMessagePath, this.srcCharset, context);
                            return parquetSourceData;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

