/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.commons.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ClassUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.source.http.HTTPBadRequestException;
import org.apache.flume.source.http.JSONHandler;
import org.apache.inlong.sdk.commons.admin.AdminEventHandler;
import org.apache.inlong.sdk.commons.admin.AdminHttpSourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminJsonHandler
implements AdminHttpSourceHandler {
    public static final Logger LOG = LoggerFactory.getLogger(AdminJsonHandler.class);
    public static final String KEY_CMD = "cmd";
    private Context context;
    private JSONHandler requestHandler;
    private Map<String, AdminEventHandler> handlerMap = new HashMap<String, AdminEventHandler>();

    public void configure(Context context) {
        this.context = context;
        this.requestHandler = new JSONHandler();
        this.requestHandler.configure(context);
    }

    @Override
    public List<Event> getEvents(HttpServletRequest request, HttpServletResponse response) throws HTTPBadRequestException, Exception {
        List events = this.requestHandler.getEvents(request);
        for (Event event : events) {
            AdminEventHandler handler;
            String cmd;
            block7: {
                cmd = (String)event.getHeaders().get(KEY_CMD);
                if (cmd == null) {
                    LOG.error("Invalid admin event,{} is null", (Object)KEY_CMD);
                    continue;
                }
                handler = this.handlerMap.get(cmd);
                if (handler == null) {
                    String handlerType = this.context.getString(cmd + ".type");
                    if (handlerType == null) {
                        LOG.error("Invalid admin event,{}:{},type is null", (Object)KEY_CMD, (Object)cmd);
                        continue;
                    }
                    try {
                        Class handlerClass = ClassUtils.getClass((String)handlerType);
                        Object handlerObject = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (handlerObject instanceof AdminEventHandler) {
                            handler = (AdminEventHandler)handlerObject;
                            Context subContext = new Context(this.context.getSubProperties(cmd + "."));
                            handler.configure(subContext);
                            this.handlerMap.put(cmd, handler);
                            break block7;
                        }
                        LOG.error("Invalid admin event,{}:{},type:{} is not AdminEventHandler", new Object[]{KEY_CMD, cmd, handlerType});
                    }
                    catch (Exception e) {
                        LOG.error("Invalid admin event,{}:{},type:{} can not be created,error:{}", new Object[]{KEY_CMD, cmd, handlerType, e.getMessage(), e});
                    }
                    continue;
                }
            }
            handler.process(cmd, event, response);
        }
        return null;
    }
}

