/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.trace;

import com.fasterxml.jackson.databind.JsonNode;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.web.trace.ResponseWrapper;
import org.apache.inlong.manager.web.utils.InlongRequestWrapper;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TraceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TraceFilter.class);
    private static final String INLONG_GROUP_ID = "inlongGroupId";
    private static final String CLUSTER_NAME = "clusterName";
    private static final String CLUSTER_TAG = "clusterTag";
    private static final String INLONG_STREAM = "inlongStreamId";
    private static final String TRACE_ID = "trace-id";
    private static final String REQUEST = "request";
    private static final String BODY = "body";
    private static final String URI = "URI";
    private static final String RESPONSE = "response";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        InlongRequestWrapper inlongRequestWrapper;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (request instanceof ShiroHttpServletRequest) {
            ShiroHttpServletRequest shiroWrapper = (ShiroHttpServletRequest)request;
            inlongRequestWrapper = (InlongRequestWrapper)shiroWrapper.getRequest();
        } else if (request instanceof InlongRequestWrapper) {
            inlongRequestWrapper = (InlongRequestWrapper)request;
        } else {
            String errMsg = "request should be one of ShiroHttpServletRequest or InlongRequestWrapper type";
            log.error(errMsg);
            response.sendError(500, errMsg);
            return;
        }
        ResponseWrapper responseWrapper = new ResponseWrapper(response);
        Span span = Span.current();
        this.addAttributes(inlongRequestWrapper.getContent(), request);
        span.addEvent(REQUEST, Attributes.builder().put(BODY, inlongRequestWrapper.getContent()).put(URI, request.getRequestURI()).build());
        response.addHeader(TRACE_ID, span.getSpanContext().getTraceId());
        filterChain.doFilter((ServletRequest)inlongRequestWrapper, (ServletResponse)responseWrapper);
        span.addEvent(RESPONSE, Attributes.builder().put(BODY, responseWrapper.getContent()).build());
    }

    private void addAttributes(String body, HttpServletRequest request) {
        try {
            JsonNode jsonNode = JsonUtils.parseTree((String)body);
            this.addParamInBody(jsonNode, INLONG_GROUP_ID);
            this.addParamInBody(jsonNode, CLUSTER_NAME);
            this.addParamInBody(jsonNode, CLUSTER_TAG);
            this.addParamInBody(jsonNode, INLONG_STREAM);
            this.addParamInURI(request, INLONG_GROUP_ID);
            this.addParamInURI(request, CLUSTER_NAME);
            this.addParamInURI(request, CLUSTER_TAG);
            this.addParamInURI(request, INLONG_STREAM);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void addParamInBody(JsonNode jsonNode, String paramName) {
        JsonNode nodeValue = jsonNode.get(paramName);
        if (nodeValue != null) {
            Span.current().setAttribute(paramName, nodeValue.asText());
        }
    }

    private void addParamInURI(HttpServletRequest request, String paramName) {
        String param = request.getParameter(paramName);
        if (StringUtils.isNotBlank((String)param)) {
            Span.current().setAttribute(paramName, param);
        }
    }
}

