/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.stream;

import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.listener.StreamTaskListenerFactory;
import org.apache.inlong.manager.service.listener.stream.UpdateStreamCompleteListener;
import org.apache.inlong.manager.service.listener.stream.UpdateStreamFailedListener;
import org.apache.inlong.manager.service.listener.stream.UpdateStreamListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestartStreamWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(RestartStreamWorkflowDefinition.class);
    @Autowired
    private UpdateStreamListener updateStreamListener;
    @Autowired
    private UpdateStreamCompleteListener updateStreamCompleteListener;
    @Autowired
    private UpdateStreamFailedListener updateStreamFailedListener;
    @Autowired
    private StreamTaskListenerFactory streamTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(StreamResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        process.addListener((ProcessEventListener)this.updateStreamListener);
        process.addListener((ProcessEventListener)this.updateStreamCompleteListener);
        process.addListener((ProcessEventListener)this.updateStreamFailedListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask restartSortTask = new ServiceTask();
        restartSortTask.setName("RestartSort");
        restartSortTask.setDisplayName("Stream-RestartSort");
        restartSortTask.setServiceTaskType(ServiceTaskType.RESTART_SORT);
        restartSortTask.setListenerFactory((TaskListenerFactory)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)restartSortTask);
        ServiceTask restartDataSourceTask = new ServiceTask();
        restartDataSourceTask.setName("RestartSource");
        restartDataSourceTask.setDisplayName("Stream-RestartSource");
        restartDataSourceTask.setServiceTaskType(ServiceTaskType.RESTART_SOURCE);
        restartDataSourceTask.setListenerFactory((TaskListenerFactory)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)restartDataSourceTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)restartSortTask);
        restartSortTask.addNext((Element)restartDataSourceTask);
        restartDataSourceTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.RESTART_STREAM_RESOURCE;
    }
}

