/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.es;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ElasticsearchConfig {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchConfig.class);
    private final Random rand = new Random();
    @Autowired
    private RestTemplate restTemplate;
    private List<HttpHost> httpHosts;
    private String hosts;
    private Boolean authEnable = false;
    private String username;
    private String password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestTemplate getRestClient() {
        if (this.restTemplate != null) {
            return this.restTemplate;
        }
        try {
            Class<RestTemplate> clazz = RestTemplate.class;
            synchronized (RestTemplate.class) {
                if (this.restTemplate == null) {
                    this.restTemplate = new RestTemplate();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            logger.error("get es high level client error", (Throwable)e);
        }
        {
            return this.restTemplate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpHost> getHttpHosts() {
        if (this.httpHosts != null) {
            return this.httpHosts;
        }
        try {
            Class<HttpHost> clazz = HttpHost.class;
            synchronized (HttpHost.class) {
                String[] hostArrays;
                this.httpHosts = new ArrayList<HttpHost>();
                for (String host : hostArrays = this.hosts.split(";")) {
                    if (!StringUtils.isNotBlank((CharSequence)host)) continue;
                    host = host.trim();
                    this.httpHosts.add(HttpHost.create((String)host));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            logger.error("get es http hosts error", (Throwable)e);
        }
        {
            return this.httpHosts;
        }
    }

    public String getOneHttpUrl() throws Exception {
        this.getHttpHosts();
        if (!this.httpHosts.isEmpty() && this.httpHosts.size() > 0) {
            return this.httpHosts.get(this.rand.nextInt(this.httpHosts.size())).toString();
        }
        throw new Exception("http hosts is empty! please check hosts!");
    }

    public String[] getHttpUrls(String urlSuffix) throws Exception {
        this.getHttpHosts();
        if (!this.httpHosts.isEmpty() && this.httpHosts.size() > 0) {
            String[] urls = new String[this.httpHosts.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = this.httpHosts.get(i) + urlSuffix;
            }
            return urls;
        }
        throw new Exception("http hosts is empty! please check hosts!");
    }

    public Random getRand() {
        return this.rand;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public String getHosts() {
        return this.hosts;
    }

    public Boolean getAuthEnable() {
        return this.authEnable;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setHttpHosts(List<HttpHost> httpHosts) {
        this.httpHosts = httpHosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setAuthEnable(Boolean authEnable) {
        this.authEnable = authEnable;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchConfig)) {
            return false;
        }
        ElasticsearchConfig other = (ElasticsearchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$authEnable = this.getAuthEnable();
        Boolean other$authEnable = other.getAuthEnable();
        if (this$authEnable == null ? other$authEnable != null : !((Object)this$authEnable).equals(other$authEnable)) {
            return false;
        }
        Random this$rand = this.getRand();
        Random other$rand = other.getRand();
        if (this$rand == null ? other$rand != null : !this$rand.equals(other$rand)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        List<HttpHost> this$httpHosts = this.getHttpHosts();
        List<HttpHost> other$httpHosts = other.getHttpHosts();
        if (this$httpHosts == null ? other$httpHosts != null : !((Object)this$httpHosts).equals(other$httpHosts)) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $authEnable = this.getAuthEnable();
        result = result * 59 + ($authEnable == null ? 43 : ((Object)$authEnable).hashCode());
        Random $rand = this.getRand();
        result = result * 59 + ($rand == null ? 43 : $rand.hashCode());
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        List<HttpHost> $httpHosts = this.getHttpHosts();
        result = result * 59 + ($httpHosts == null ? 43 : ((Object)$httpHosts).hashCode());
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticsearchConfig(rand=" + this.getRand() + ", restTemplate=" + this.getRestTemplate() + ", httpHosts=" + this.getHttpHosts() + ", hosts=" + this.getHosts() + ", authEnable=" + this.getAuthEnable() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

