/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.datatype;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.pojo.sort.dataflow.dataType.DataTypeConfig;
import org.apache.inlong.common.pojo.sort.dataflow.dataType.KvConfig;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.datatype.DataTypeOperator;
import org.apache.inlong.sdk.transform.decode.KvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KvDataTypeOperator
implements DataTypeOperator {
    private static final Logger log = LoggerFactory.getLogger(KvDataTypeOperator.class);

    @Override
    public boolean accept(DataTypeEnum type) {
        return DataTypeEnum.KV.equals((Object)type);
    }

    @Override
    public List<BriefMQMessage.FieldInfo> parseFields(String str, InlongStreamInfo streamInfo) throws Exception {
        List fields = CommonBeanUtils.copyListProperties((List)streamInfo.getFieldList(), BriefMQMessage.FieldInfo::new);
        try {
            char separator = '\u0000';
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataSeparator())) {
                separator = (char)Integer.parseInt(streamInfo.getDataSeparator());
            }
            char kvSeparator = '=';
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getKvSeparator())) {
                kvSeparator = (char)Integer.parseInt(streamInfo.getKvSeparator());
            }
            Character escapeChar = null;
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataEscapeChar())) {
                escapeChar = Character.valueOf(streamInfo.getDataEscapeChar().charAt(0));
            }
            Character lineSeparator = null;
            if (StringUtils.isNotBlank((CharSequence)streamInfo.getLineSeparator())) {
                lineSeparator = Character.valueOf((char)Integer.parseInt(streamInfo.getLineSeparator()));
            }
            List rowValues = KvUtils.splitKv((String)str, (Character)Character.valueOf(separator), (Character)Character.valueOf(kvSeparator), (Character)escapeChar, null, (Character)lineSeparator);
            for (Map row : rowValues) {
                for (BriefMQMessage.FieldInfo fieldInfo : fields) {
                    fieldInfo.setFieldValue((String)row.get(fieldInfo.getFieldName()));
                }
            }
        }
        catch (Exception e) {
            log.warn("parse fields failed for groupId = {}, streamId = {}", new Object[]{streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId(), e});
        }
        return fields;
    }

    @Override
    public DataTypeConfig getDataTypeConfig(InlongStreamInfo streamInfo) {
        char separator = '\u0000';
        if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataSeparator())) {
            separator = (char)Integer.parseInt(streamInfo.getDataSeparator());
        }
        Character escape = null;
        if (StringUtils.isNotBlank((CharSequence)streamInfo.getDataEscapeChar())) {
            escape = Character.valueOf(streamInfo.getDataEscapeChar().charAt(0));
        }
        KvConfig kvConfig = new KvConfig();
        char kvSeparator = '=';
        Character lineSeparator = null;
        if (StringUtils.isNotBlank((CharSequence)streamInfo.getKvSeparator())) {
            kvSeparator = (char)Integer.parseInt(streamInfo.getKvSeparator());
        }
        if (StringUtils.isNotBlank((CharSequence)streamInfo.getLineSeparator())) {
            lineSeparator = Character.valueOf((char)Integer.parseInt(streamInfo.getLineSeparator()));
        }
        kvConfig.setLineSeparator(lineSeparator);
        kvConfig.setKvSplitter(Character.valueOf(kvSeparator));
        kvConfig.setEntrySplitter(Character.valueOf(separator));
        kvConfig.setEscapeChar(escape);
        return kvConfig;
    }
}

