/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.quartz;

import org.apache.inlong.common.bounded.BoundaryType;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.impl.InlongClientImpl;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.InlongGroupClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.auth.DefaultAuthentication;
import org.apache.inlong.manager.pojo.schedule.OfflineJobRequest;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QuartzOfflineSyncJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzOfflineSyncJob.class);
    private volatile InlongGroupClient groupClient;
    private long endTime;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("QuartzOfflineSyncJob run once");
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        this.initGroupClient(jobDataMap);
        String inlongGroupId = context.getJobDetail().getKey().getName();
        long lowerBoundary = context.getScheduledFireTime().getTime();
        long upperBoundary = context.getNextFireTime() == null ? this.endTime : context.getNextFireTime().getTime();
        OfflineJobRequest request = new OfflineJobRequest();
        request.setGroupId(inlongGroupId);
        request.setBoundaryType(BoundaryType.TIME.getType());
        request.setLowerBoundary(String.valueOf(lowerBoundary));
        request.setUpperBoundary(String.valueOf(upperBoundary));
        LOGGER.info("Starting submit offline job for group: {}, with lower boundary: {} and upper boundary: {}", new Object[]{inlongGroupId, lowerBoundary, upperBoundary});
        try {
            if (this.groupClient.submitOfflineJob(request).booleanValue()) {
                LOGGER.info("Successfully submitting offline job for group {}", (Object)inlongGroupId);
            } else {
                LOGGER.warn("Failed to submit offline job for group {}", (Object)inlongGroupId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception to submit offline job for group {}, error msg: {}", (Object)inlongGroupId, (Object)e.getMessage());
        }
    }

    private void initGroupClient(JobDataMap jobDataMap) {
        if (this.groupClient == null) {
            String host = (String)jobDataMap.get((Object)"HOST");
            int port = (Integer)jobDataMap.get((Object)"PORT");
            String username = (String)jobDataMap.get((Object)"USERNAME");
            String password = (String)jobDataMap.get((Object)"PASSWORD");
            this.endTime = (Long)jobDataMap.get((Object)"END_TIME");
            LOGGER.info("Initializing Inlong group client, with host: {}, port: {}, userName : {}, endTime: {}", new Object[]{host, port, username, this.endTime});
            ClientConfiguration configuration = new ClientConfiguration();
            configuration.setAuthentication((Authentication)new DefaultAuthentication(username, password));
            String serviceUrl = host + ":" + port;
            InlongClientImpl inlongClient = new InlongClientImpl(serviceUrl, configuration);
            ClientFactory clientFactory = ClientUtils.getClientFactory((ClientConfiguration)inlongClient.getConfiguration());
            this.groupClient = clientFactory.getGroupClient();
        }
    }

    public InlongGroupClient getGroupClient() {
        return this.groupClient;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setGroupClient(InlongGroupClient groupClient) {
        this.groupClient = groupClient;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuartzOfflineSyncJob)) {
            return false;
        }
        QuartzOfflineSyncJob other = (QuartzOfflineSyncJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        InlongGroupClient this$groupClient = this.getGroupClient();
        InlongGroupClient other$groupClient = other.getGroupClient();
        return !(this$groupClient == null ? other$groupClient != null : !this$groupClient.equals(other$groupClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuartzOfflineSyncJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        InlongGroupClient $groupClient = this.getGroupClient();
        result = result * 59 + ($groupClient == null ? 43 : $groupClient.hashCode());
        return result;
    }

    public String toString() {
        return "QuartzOfflineSyncJob(groupClient=" + this.getGroupClient() + ", endTime=" + this.getEndTime() + ")";
    }

    public QuartzOfflineSyncJob() {
    }

    public QuartzOfflineSyncJob(InlongGroupClient groupClient, long endTime) {
        this.groupClient = groupClient;
        this.endTime = endTime;
    }
}

