/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.inlong.manager.plugin.flink.dto.FlinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkUtils {
    private static final Logger log = LoggerFactory.getLogger(FlinkUtils.class);
    public static final String BASE_DIRECTORY = "config";
    private static final String DEFAULT_PLUGINS = "plugins";
    private static final String FILE_PREFIX = "file://";
    private static final String DEFAULT_CONFIG_FILE = "flink-sort-plugin.properties";

    public static String getExceptionStackMsg(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.getBuffer().toString();
    }

    public static String findFile(String baseDirName, String pattern) {
        List<String> files = FlinkUtils.listFiles(baseDirName, pattern, 1);
        if (CollectionUtils.isEmpty(files)) {
            return null;
        }
        return files.get(0);
    }

    public static List<String> listFiles(String baseDirName, String pattern, int limit) {
        ArrayList<String> result = new ArrayList<String>();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            log.error("baseDirName find fail: {}", (Object)baseDirName);
            return result;
        }
        File[] files = baseDir.listFiles();
        if (files == null || files.length == 0) {
            log.info("baseDirName is empty");
            return result;
        }
        File[] fileArray = files;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file;
            File tempFile = file = fileArray[i];
            String tempName = tempFile.getName();
            Pattern jarPathPattern = Pattern.compile(pattern);
            Matcher matcher = jarPathPattern.matcher(tempName);
            boolean matches = matcher.matches();
            if (matches) {
                result.add(tempFile.getAbsoluteFile().toString());
            }
            if (limit <= 0 || result.size() < limit) continue;
            return result;
        }
        return result;
    }

    public static String getConfigDirectory(String name) {
        return BASE_DIRECTORY + File.separator + name;
    }

    public static boolean writeConfigToFile(String configJobDirectory, String configFileName, String content) {
        File file = new File(configJobDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
        String filePath = configJobDirectory + File.separator + configFileName;
        try {
            FileWriter fileWriter = new FileWriter(filePath);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(content);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            log.error("saveConfigToLocal failed", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getFlinkClientService(Configuration configuration, FlinkConfig flinkConfig) {
        log.info("Flink version {}", (Object)flinkConfig.getVersion());
        Path pluginPath = Paths.get(DEFAULT_PLUGINS, new String[0]).toAbsolutePath();
        String flinkJarName = String.format("manager-plugins-flink-v%s.jar", flinkConfig.getVersion());
        String flinkClientPath = FILE_PREFIX + pluginPath + File.separator + flinkJarName;
        log.info("Start to load Flink jar: {}", (Object)flinkClientPath);
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{new URL(flinkClientPath)}, Thread.currentThread().getContextClassLoader());){
            Class<?> flinkClientService = classLoader.loadClass("org.apache.inlong.manager.plugin.flink.FlinkClientService");
            Object flinkService = flinkClientService.getDeclaredConstructor(Configuration.class).newInstance(configuration);
            log.info("Successfully loaded Flink service");
            Object obj = flinkService;
            return obj;
        }
        catch (Exception e) {
            log.error("Failed to loaded Flink service, please check flink client jar path: {}", (Object)flinkClientPath);
            throw new RuntimeException(e);
        }
    }

    public static FlinkConfig getFlinkConfigFromFile() throws Exception {
        Path pluginPath = Paths.get(DEFAULT_PLUGINS, new String[0]).toAbsolutePath();
        String defaultConfigFilePath = pluginPath + File.separator + DEFAULT_CONFIG_FILE;
        log.info("Start to load Flink config from file: {}", (Object)defaultConfigFilePath);
        Properties properties = new Properties();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(defaultConfigFilePath));){
            properties.load(bufferedReader);
        }
        FlinkConfig flinkConfig = new FlinkConfig();
        flinkConfig.setPort(Integer.valueOf(properties.getProperty("flink.rest.port")));
        flinkConfig.setAddress(properties.getProperty("flink.rest.address"));
        flinkConfig.setParallelism(Integer.valueOf(properties.getProperty("flink.parallelism")));
        flinkConfig.setSavepointDirectory(properties.getProperty("flink.savepoint.directory"));
        flinkConfig.setJobManagerPort(Integer.valueOf(properties.getProperty("flink.jobmanager.port")));
        flinkConfig.setDrain(Boolean.parseBoolean(properties.getProperty("flink.drain")));
        flinkConfig.setAuditProxyHosts(properties.getProperty("metrics.audit.proxy.hosts"));
        flinkConfig.setVersion(properties.getProperty("flink.version"));
        return flinkConfig;
    }
}

