/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.auth.SecretTokenAuthentication;
import org.apache.inlong.manager.common.auth.TokenAuthentication;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.sort.BaseSortConf;
import org.apache.inlong.manager.pojo.sort.FlinkSortConf;
import org.apache.inlong.manager.pojo.sort.UserDefinedSortConf;

public class InlongGroupTransfer {
    public static InlongGroupInfo createGroupInfo(InlongGroupInfo groupInfo, BaseSortConf sortConf) {
        List<InlongGroupExtInfo> sortExtInfos;
        Preconditions.expectNotNull((Object)groupInfo, (String)"Inlong group info cannot be null");
        String groupId = groupInfo.getInlongGroupId();
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        if (groupInfo.getExtList() == null) {
            groupInfo.setExtList(new ArrayList());
        }
        ArrayList<InlongGroupExtInfo> extInfos = new ArrayList<InlongGroupExtInfo>();
        if (groupInfo.getAuthentication() != null) {
            Authentication authentication = groupInfo.getAuthentication();
            Authentication.AuthType authType = authentication.getAuthType();
            Preconditions.expectTrue((authType == Authentication.AuthType.TOKEN ? 1 : 0) != 0, (String)String.format("Unsupported authentication %s for Pulsar", authType.name()));
            TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
            InlongGroupExtInfo authTypeExt = new InlongGroupExtInfo();
            authTypeExt.setKeyName("pulsar.authentication.type");
            authTypeExt.setKeyValue(tokenAuthentication.getAuthType().toString());
            extInfos.add(authTypeExt);
            InlongGroupExtInfo authValue = new InlongGroupExtInfo();
            authValue.setKeyName("pulsar.authentication");
            authValue.setKeyValue(tokenAuthentication.getToken());
            extInfos.add(authValue);
            groupInfo.getExtList().addAll(extInfos);
        }
        if (sortConf == null) {
            throw new IllegalArgumentException("sort config cannot be empty for group=" + groupId);
        }
        BaseSortConf.SortType sortType = sortConf.getType();
        if (sortType == BaseSortConf.SortType.FLINK) {
            FlinkSortConf flinkSortConf = (FlinkSortConf)sortConf;
            sortExtInfos = InlongGroupTransfer.createFlinkExtInfo(flinkSortConf);
        } else if (sortType == BaseSortConf.SortType.USER_DEFINED) {
            UserDefinedSortConf udf = (UserDefinedSortConf)sortConf;
            sortExtInfos = InlongGroupTransfer.createUserDefinedSortExtInfo(udf);
        } else {
            sortExtInfos = new ArrayList<InlongGroupExtInfo>();
        }
        groupInfo.getExtList().addAll(sortExtInfos);
        return groupInfo;
    }

    public static List<InlongGroupExtInfo> createFlinkExtInfo(FlinkSortConf flinkSortConf) {
        ArrayList<InlongGroupExtInfo> extInfos = new ArrayList<InlongGroupExtInfo>();
        InlongGroupExtInfo sortType = new InlongGroupExtInfo();
        sortType.setKeyName("sort.type");
        sortType.setKeyValue(BaseSortConf.SortType.FLINK.getType());
        extInfos.add(sortType);
        if (flinkSortConf.getAuthentication() != null) {
            Authentication authentication = flinkSortConf.getAuthentication();
            Authentication.AuthType authType = authentication.getAuthType();
            Preconditions.expectTrue((authType == Authentication.AuthType.SECRET_AND_TOKEN ? 1 : 0) != 0, (String)String.format("Unsupported authentication %s for Flink", authType.name()));
            SecretTokenAuthentication secretTokenAuthentication = (SecretTokenAuthentication)authentication;
            InlongGroupExtInfo authTypeExt = new InlongGroupExtInfo();
            authTypeExt.setKeyName("sort.authentication.type");
            authTypeExt.setKeyValue(authType.toString());
            extInfos.add(authTypeExt);
            InlongGroupExtInfo authValue = new InlongGroupExtInfo();
            authValue.setKeyName("sort.authentication");
            authValue.setKeyValue(secretTokenAuthentication.toString());
            extInfos.add(authValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)flinkSortConf.getServiceUrl())) {
            InlongGroupExtInfo flinkUrl = new InlongGroupExtInfo();
            flinkUrl.setKeyName("sort.url");
            flinkUrl.setKeyValue(flinkSortConf.getServiceUrl());
            extInfos.add(flinkUrl);
        }
        if (MapUtils.isNotEmpty((Map)flinkSortConf.getProperties())) {
            InlongGroupExtInfo flinkProperties = new InlongGroupExtInfo();
            flinkProperties.setKeyName("sort.properties");
            try {
                flinkProperties.setKeyValue(JsonUtils.toJsonString((Object)flinkSortConf.getProperties()));
            }
            catch (Exception e) {
                throw new RuntimeException("get json for sort properties error: " + e.getMessage());
            }
            extInfos.add(flinkProperties);
        }
        return extInfos;
    }

    public static List<InlongGroupExtInfo> createUserDefinedSortExtInfo(UserDefinedSortConf userDefinedSortConf) {
        ArrayList<InlongGroupExtInfo> extInfos = new ArrayList<InlongGroupExtInfo>();
        InlongGroupExtInfo sortType = new InlongGroupExtInfo();
        sortType.setKeyName("sort.type");
        sortType.setKeyValue(BaseSortConf.SortType.USER_DEFINED.getType());
        extInfos.add(sortType);
        InlongGroupExtInfo sortName = new InlongGroupExtInfo();
        sortName.setKeyName("sort.name");
        sortName.setKeyValue(userDefinedSortConf.getSortName());
        extInfos.add(sortName);
        if (MapUtils.isNotEmpty((Map)userDefinedSortConf.getProperties())) {
            InlongGroupExtInfo flinkProperties = new InlongGroupExtInfo();
            flinkProperties.setKeyName("sort.properties");
            try {
                flinkProperties.setKeyValue(JsonUtils.toJsonString((Object)userDefinedSortConf.getProperties()));
            }
            catch (Exception e) {
                throw new RuntimeException("get json for sort properties error: " + e.getMessage());
            }
            extInfos.add(flinkProperties);
        }
        return extInfos;
    }
}

