/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.utils;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtils {
    private static final Logger logger = LoggerFactory.getLogger(AddressUtils.class);

    public static String getChannelLocalIP(Channel channel) {
        return AddressUtils.getChannelIP(channel, true);
    }

    public static String getChannelRemoteIP(Channel channel) {
        return AddressUtils.getChannelIP(channel, false);
    }

    private static String getChannelIP(Channel channel, boolean isLocal) {
        SocketAddress address;
        if (channel == null) {
            return null;
        }
        SocketAddress socketAddress = address = isLocal ? channel.localAddress() : channel.remoteAddress();
        if (address == null) {
            return null;
        }
        String strAddrIP = address.toString();
        try {
            strAddrIP = strAddrIP.substring(1, strAddrIP.indexOf(58));
            return strAddrIP;
        }
        catch (Exception ee) {
            if (isLocal) {
                logger.warn("Fail to get the local IP, localAddress = {}", (Object)address);
            } else {
                logger.warn("Fail to get the remote IP, remoteAddress = {}", (Object)address);
            }
            return null;
        }
    }
}

