/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import org.apache.flume.Event;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;

public abstract class PackProfile {
    private final String inlongGroupId;
    private final String inlongStreamId;
    private final long dispatchTime;
    private final long createTime = System.currentTimeMillis();
    private final String uid;
    protected long count = 0L;
    protected long size = 0L;
    protected final boolean enableRetryAfterFailure;
    protected final int maxRetries;
    protected int retries = 0;

    public PackProfile(String uid, String inlongGroupId, String inlongStreamId, long dispatchTime) {
        this.uid = uid;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.dispatchTime = dispatchTime;
        this.enableRetryAfterFailure = CommonConfigHolder.getInstance().isEnableSendRetryAfterFailure();
        this.maxRetries = CommonConfigHolder.getInstance().getMaxRetriesAfterFailure();
    }

    public String getUid() {
        return this.uid;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public long getDispatchTime() {
        return this.dispatchTime;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isTimeout(long createThreshold) {
        return createThreshold >= this.createTime;
    }

    public abstract void ack();

    public abstract void fail(DataProxyErrCode var1, String var2);

    public abstract boolean isResend();

    public abstract boolean addEvent(Event var1, long var2, long var4);
}

