/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.utils;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    public static final String KEY_FILE_STATUS_CHECK = "_file_status_check";
    public static final String KEY_SECRET_ID = "_secretId";
    public static final String KEY_SIGNATURE = "_signature";
    public static final String KEY_TIME_STAMP = "_timeStamp";
    public static final String KEY_NONCE = "_nonce";
    public static final String KEY_USERNAME = "_userName";
    public static final String KEY_CLIENT_IP = "_clientIP";
    public static final String KEY_ENCY_VERSION = "_encyVersion";
    public static final String KEY_ENCY_AES_KEY = "_encyAesKey";
    private static final Logger logger = LoggerFactory.getLogger(ProxyUtils.class);
    private static final LogCounter exceptCounter = new LogCounter(10L, 200000L, 60000L);
    private static final int TIME_LENGTH = 13;
    public static final Set<String> SdkReservedWords = new HashSet<String>();
    public static final Set<MsgType> SdkAllowedMsgType = new HashSet<MsgType>();
    private static String localHost;
    private static String sdkVersion;
    private static Integer sdkProcessId;

    public static String getLocalIp() {
        String ip;
        block15: {
            if (localHost != null) {
                return localHost;
            }
            ip = "127.0.0.1";
            try (DatagramSocket socket = new DatagramSocket();){
                socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
                ip = socket.getLocalAddress().getHostAddress();
            }
            catch (Throwable ex) {
                if (!exceptCounter.shouldPrint()) break block15;
                logger.error("DataProxy-SDK get local IP failure", ex);
            }
        }
        localHost = ip;
        return ip;
    }

    public static String getJarVersion() {
        block18: {
            if (sdkVersion != null) {
                return sdkVersion;
            }
            try (InputStream is = ProxyUtils.class.getClassLoader().getResourceAsStream("sdk.version");){
                if (is == null) {
                    sdkVersion = "unknown";
                    if (exceptCounter.shouldPrint()) {
                        logger.error("Missing sdk.version file!");
                    }
                } else {
                    Properties properties = new Properties();
                    properties.load(is);
                    sdkVersion = properties.getProperty("version");
                }
            }
            catch (Throwable ex) {
                sdkVersion = "unknown";
                if (!exceptCounter.shouldPrint()) break block18;
                logger.error("DataProxy-SDK get version failure", ex);
            }
        }
        return sdkVersion;
    }

    public static Integer getProcessPid() {
        block3: {
            if (sdkProcessId != null) {
                return sdkProcessId;
            }
            try {
                String processName = ManagementFactory.getRuntimeMXBean().getName();
                sdkProcessId = Integer.parseInt(processName.split("@")[0]);
            }
            catch (Throwable ex) {
                if (!exceptCounter.shouldPrint()) break block3;
                logger.error("DataProxy-SDK get process ID failure", ex);
            }
        }
        return sdkProcessId;
    }

    public static boolean sleepSomeTime(long sleepTimeMs) {
        try {
            Thread.sleep(sleepTimeMs);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static String buildClusterIdKey(String protocol, String regionName, Integer clusterId) {
        return clusterId + ":" + regionName + ":" + protocol;
    }

    public static String buildGroupIdConfigKey(String protocol, String regionName, String groupId) {
        return protocol + ":" + regionName + ":" + groupId;
    }

    public static Map<String, String> getValidAttrs(Map<String, String> attrsMap) {
        if (attrsMap == null || attrsMap.isEmpty()) {
            return attrsMap;
        }
        HashMap<String, String> validAttrsMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attrsMap.entrySet()) {
            String tmpValue;
            if (StringUtils.isBlank(entry.getKey()) || entry.getKey().contains("&") || entry.getKey().contains("=") || SdkReservedWords.contains(tmpValue = entry.getKey().trim()) || entry.getValue() != null && (entry.getValue().contains("&") || entry.getValue().contains("="))) continue;
            validAttrsMap.put(tmpValue, entry.getValue());
        }
        return validAttrsMap;
    }

    static {
        ProxyUtils.getLocalIp();
        ProxyUtils.getProcessPid();
        ProxyUtils.getJarVersion();
        Collections.addAll(SdkReservedWords, "groupId", "streamId", "dt", "msgUUID", "cp", "cnt", "mt", "m", "sid", "t", "NodeIP", "messageId", "isAck", "proxySend", "errCode", "errMsg", "rtms", "sdkVersion", KEY_FILE_STATUS_CHECK, KEY_SECRET_ID, KEY_SIGNATURE, KEY_TIME_STAMP, KEY_NONCE, KEY_USERNAME, KEY_CLIENT_IP, KEY_ENCY_VERSION, KEY_ENCY_AES_KEY);
        Collections.addAll(SdkAllowedMsgType, MsgType.MSG_ACK_SERVICE, MsgType.MSG_MULTI_BODY, MsgType.MSG_BIN_MULTI_BODY);
    }
}

