/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.metric;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class TimeCostInfo {
    private final String name;
    private final ConcurrentHashMap<String, LongAdder> sendTimeBucketT = new ConcurrentHashMap();
    private final LongAdder sumTime = new LongAdder();
    private final AtomicLong maxValue = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong minValue = new AtomicLong(Long.MAX_VALUE);
    private final LongAdder totalCnt = new LongAdder();

    public TimeCostInfo(String name) {
        this.name = name;
    }

    public void addTimeCostInMs(long timeInMs) {
        this.sumTime.add(timeInMs);
        this.totalCnt.increment();
        this.updateMin(timeInMs);
        this.updateMax(timeInMs);
        if (timeInMs < 2L) {
            this.addTimeCostBucketT("0t2");
        } else if (timeInMs < 4L) {
            this.addTimeCostBucketT("2t4");
        } else if (timeInMs < 8L) {
            this.addTimeCostBucketT("4t8");
        } else if (timeInMs < 16L) {
            this.addTimeCostBucketT("8t16");
        } else if (timeInMs < 32L) {
            this.addTimeCostBucketT("16t32");
        } else if (timeInMs < 96L) {
            this.addTimeCostBucketT("32t96");
        } else if (timeInMs < 128L) {
            this.addTimeCostBucketT("96t128");
        } else if (timeInMs < 256L) {
            this.addTimeCostBucketT("128t256");
        } else if (timeInMs < 512L) {
            this.addTimeCostBucketT("256t512");
        } else if (timeInMs < 1024L) {
            this.addTimeCostBucketT("512t1024");
        } else if (timeInMs < 20480L) {
            this.addTimeCostBucketT("1024t20480");
        } else {
            this.addTimeCostBucketT("20480t+\u221e");
        }
    }

    public void getAndResetValue(StringBuilder strBuff) {
        long curTotalCnt = this.totalCnt.sumThenReset();
        if (curTotalCnt == 0L) {
            strBuff.append("\"").append(this.name).append("\":{\"bkts\":{},\"min\":0,\"max\":0,\"avgT\":0}");
        } else {
            long bucketCnt = 0L;
            strBuff.append("\"").append(this.name).append("\":{\"bkts\":{");
            for (Map.Entry<String, LongAdder> entry : this.sendTimeBucketT.entrySet()) {
                if (bucketCnt++ > 0L) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(entry.getKey()).append("\":").append(entry.getValue());
            }
            strBuff.append("},\"min\":").append(this.minValue.getAndSet(Long.MAX_VALUE)).append(",\"max\":").append(this.maxValue.getAndSet(Long.MIN_VALUE)).append(",\"avgT\":").append(this.sumTime.sumThenReset() / curTotalCnt).append("}");
            this.sendTimeBucketT.clear();
        }
    }

    public void clear() {
        this.sendTimeBucketT.clear();
        this.totalCnt.reset();
        this.sumTime.reset();
        this.minValue.set(Long.MAX_VALUE);
        this.maxValue.set(Long.MIN_VALUE);
    }

    private void updateMin(long newValue) {
        long cur;
        while (newValue < (cur = this.minValue.get()) && !this.minValue.compareAndSet(cur, newValue)) {
        }
    }

    private void updateMax(long newValue) {
        long cur;
        while (newValue > (cur = this.maxValue.get()) && !this.maxValue.compareAndSet(cur, newValue)) {
        }
    }

    private void addTimeCostBucketT(String key) {
        LongAdder tmpCount;
        LongAdder longCount = this.sendTimeBucketT.get(key);
        if (longCount == null && (longCount = this.sendTimeBucketT.putIfAbsent(key, tmpCount = new LongAdder())) == null) {
            longCount = tmpCount;
        }
        longCount.increment();
    }
}

