/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.inlong.manager.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final Gson GSON = new GsonBuilder().create();

    public static <T> T request(RestTemplate restTemplate, String url, HttpMethod httpMethod, Object requestBody, MultiValueMap<String, String> header, ParameterizedTypeReference<T> typeReference) {
        if (log.isDebugEnabled()) {
            log.debug("begin request to {} by request body {}", (Object)url, (Object)GSON.toJson(requestBody));
        }
        HttpEntity requestEntity = new HttpEntity(requestBody, header);
        ResponseEntity response = restTemplate.exchange(url, httpMethod, requestEntity, typeReference, new Object[0]);
        log.debug("success request to {}, status code {}", (Object)url, (Object)response.getStatusCode());
        Preconditions.expectTrue((boolean)response.getStatusCode().is2xxSuccessful(), (String)("Request failed: " + response.getBody()));
        return (T)response.getBody();
    }
}

