/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.util;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.inlong.audit.tool.mapper.AuditMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuditSQLUtil {
    private static SqlSessionFactory sqlSessionFactory;
    private static Properties appProperties;

    public static void initialize(Properties properties) {
        appProperties = properties;
        try {
            DataSource dataSource = AuditSQLUtil.createDataSourceFromProperties();
            Configuration configuration = new Configuration();
            configuration.setEnvironment(new Environment("development", (TransactionFactory)new JdbcTransactionFactory(), dataSource));
            configuration.addMapper(AuditMapper.class);
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing MyBatis with application properties", e);
        }
    }

    private static DataSource createDataSourceFromProperties() {
        String url = appProperties.getProperty("audit.data.source.url");
        String username = appProperties.getProperty("audit.data.source.username");
        String password = appProperties.getProperty("audit.data.source.password");
        PooledDataSource dataSource = new PooledDataSource();
        dataSource.setDriver("com.mysql.cj.jdbc.Driver");
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setPoolMaximumActiveConnections(10);
        dataSource.setPoolMaximumIdleConnections(5);
        return dataSource;
    }

    public static SqlSession getSqlSession() {
        if (sqlSessionFactory == null) {
            throw new IllegalStateException("MyBatisUtil not initialized. Call initialize() first.");
        }
        return sqlSessionFactory.openSession();
    }
}

