/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.service;

import java.util.Collections;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.inlong.audit.tool.entity.AuditMetric;
import org.apache.inlong.audit.tool.mapper.AuditMapper;
import org.apache.inlong.audit.tool.util.AuditSQLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditMetricService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditMetricService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AuditMetric> getStorageAuditMetrics(String auditId, String startLogTs, String endLogTs) {
        try (SqlSession sqlSession = AuditSQLUtil.getSqlSession();){
            AuditMapper auditMapper = (AuditMapper)sqlSession.getMapper(AuditMapper.class);
            List list = auditMapper.getAuditMetrics(startLogTs, endLogTs, auditId);
            return list;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred during database query: ", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

