/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.inlong.audit.tool.config.AppConfig;
import org.apache.inlong.audit.tool.dto.AuditAlertRule;
import org.apache.inlong.audit.tool.manager.AuditAlertRuleManager;
import org.apache.inlong.audit.tool.response.Response;
import org.apache.inlong.audit.tool.util.AuditAlertRulePageRequest;
import org.apache.inlong.audit.tool.util.HttpUtil;
import org.apache.inlong.audit.tool.util.PageResult;
import org.apache.inlong.audit.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuditAlertRuleManager {
    private AppConfig appConfig;
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditAlertRuleManager.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private List<AuditAlertRule> auditAlertRuleList = new CopyOnWriteArrayList();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "audit-alert-rule-scheduler");
        t.setDaemon(true);
        return t;
    });

    public static AuditAlertRuleManager getInstance() {
        return Holder.access$100();
    }

    public synchronized void init(AppConfig appConfig) {
        if (this.appConfig != null) {
            LOGGER.warn("AuditAlertRuleManager already initialized. Ignoring re-initialization");
            return;
        }
        if (appConfig == null) {
            LOGGER.error("appConfig must not be null");
            throw new IllegalStateException("appConfig is null");
        }
        this.appConfig = appConfig;
    }

    private AuditAlertRuleManager() {
    }

    private void runFetchTaskSafe() {
        try {
            LOGGER.info("Running scheduled fetch task...");
            List rules = this.fetchAlertRulesFromManager();
            if (!rules.isEmpty()) {
                this.auditAlertRuleList = rules;
            }
            LOGGER.info("Scheduled fetch task completed. rules={}", (Object)rules.size());
        }
        catch (Exception e) {
            LOGGER.error("Error during scheduled fetch task", (Throwable)e);
        }
    }

    public synchronized void schedule() {
        int executionIntervalTime = Integer.parseInt(this.appConfig.getProperties().getProperty("audit.data.time.interval.minute"));
        if (executionIntervalTime < 0) {
            LOGGER.warn("Execution Interval Time {} is in the past. Executing immediately", (Object)executionIntervalTime);
            executionIntervalTime = 0;
        }
        this.scheduler.scheduleAtFixedRate(() -> this.runFetchTaskSafe(), 0L, executionIntervalTime, TimeUnit.MINUTES);
        LOGGER.info("Scheduled fetch task at {}", (Object)executionIntervalTime);
    }

    public List<AuditAlertRule> fetchAlertRulesFromManager() {
        List<Object> auditAlertRules = new ArrayList<AuditAlertRule>();
        try {
            String managerUrl = this.appConfig.getManagerUrl();
            String url = (managerUrl.endsWith("/") ? managerUrl.substring(0, managerUrl.length() - 1) : managerUrl) + "/api/audit/alert/rule/list";
            Map authHeader = HttpUtils.getAuthHeader((String)this.appConfig.getSecretId(), (String)this.appConfig.getSecretKey());
            LinkedMultiValueMap header = new LinkedMultiValueMap();
            authHeader.forEach((arg_0, arg_1) -> ((MultiValueMap)header).add(arg_0, arg_1));
            LOGGER.info("begin query audit alertRule list");
            Response result = (Response)HttpUtil.request((RestTemplate)this.restTemplate, (String)url, (HttpMethod)HttpMethod.POST, (Object)new AuditAlertRulePageRequest(), (MultiValueMap)header, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            LOGGER.info("success to query audit info for url ={}", (Object)url);
            if (result.isSuccess()) {
                auditAlertRules = ((PageResult)result.getData()).getList();
            } else {
                LOGGER.error("fetchAlertPolicies fail:{}", (Object)result.getErrMsg());
            }
        }
        catch (Exception e) {
            LOGGER.error("fetchAlertPolicies fail: ", (Throwable)e);
        }
        return auditAlertRules;
    }

    public List<String> getAuditIds() {
        ArrayList<String> auditIds = new ArrayList<String>();
        for (AuditAlertRule auditAlertRule : this.auditAlertRuleList) {
            List auditIdList = Arrays.stream(auditAlertRule.getAuditId().split(",")).map(String::trim).collect(Collectors.toList());
            auditIds.addAll(auditIdList);
        }
        return auditIds;
    }

    public void stop() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public List<AuditAlertRule> getAuditAlertRuleList() {
        return this.auditAlertRuleList;
    }
}

