/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.audit.tool.dto.AuditAlertCondition;

@ApiModel(value="Audit Alert Rule Configuration")
public class AuditAlertRule {
    @ApiModelProperty(value="Rule ID")
    private Integer id;
    @ApiModelProperty(value="Associated InLong Group ID", required=true)
    @NotBlank(message="InLong Group ID cannot be blank")
    private @NotBlank(message="InLong Group ID cannot be blank") String inlongGroupId;
    @ApiModelProperty(value="Associated InLong Stream ID")
    private String inlongStreamId;
    @ApiModelProperty(value="Audit ID (associated with specific audit metrics, such as send success count, delay, etc.)", required=true)
    @NotBlank(message="Audit ID cannot be blank")
    private @NotBlank(message="Audit ID cannot be blank") String auditId;
    @ApiModelProperty(value="Alert name", required=true)
    @NotBlank(message="Alert name cannot be blank")
    private @NotBlank(message="Alert name cannot be blank") String alertName;
    @ApiModelProperty(value="Trigger condition", required=true)
    @NotNull(message="Trigger condition cannot be null")
    @Valid
    private @NotNull(message="Trigger condition cannot be null") @Valid AuditAlertCondition condition;
    @ApiModelProperty(value="Alert level (INFO/WARN/ERROR/CRITICAL)")
    @Pattern(regexp="^(INFO|WARN|ERROR|CRITICAL)$", message="Alert level must be one of INFO, WARN, ERROR, or CRITICAL")
    private @Pattern(regexp="^(INFO|WARN|ERROR|CRITICAL)$", message="Alert level must be one of INFO, WARN, ERROR, or CRITICAL") String level;
    @ApiModelProperty(value="Notification type (EMAIL/SMS/HTTP)")
    @Pattern(regexp="^(EMAIL|SMS|HTTP)$", message="Notification type must be one of EMAIL, SMS, or HTTP")
    private @Pattern(regexp="^(EMAIL|SMS|HTTP)$", message="Notification type must be one of EMAIL, SMS, or HTTP") String notifyType;
    @ApiModelProperty(value="Notification recipients (separated by commas for multiple recipients)")
    private String receivers;
    @ApiModelProperty(value="Whether enabled", required=true)
    @NotNull(message="Enabled status cannot be null")
    private @NotNull(message="Enabled status cannot be null") Boolean enabled;
    @ApiModelProperty(value="Whether deleted")
    private Integer isDeleted;
    @ApiModelProperty(value="Creator name")
    private String creator;
    @ApiModelProperty(value="Modifier name")
    private String modifier;
    @ApiModelProperty(value="Create time")
    private Date createTime;
    @ApiModelProperty(value="Modify time")
    private Date modifyTime;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getAuditId() {
        return this.auditId;
    }

    public String getAlertName() {
        return this.alertName;
    }

    public AuditAlertCondition getCondition() {
        return this.condition;
    }

    public String getLevel() {
        return this.level;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public String getReceivers() {
        return this.receivers;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setAuditId(String auditId) {
        this.auditId = auditId;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }

    public void setCondition(AuditAlertCondition condition) {
        this.condition = condition;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public void setReceivers(String receivers) {
        this.receivers = receivers;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditAlertRule)) {
            return false;
        }
        AuditAlertRule other = (AuditAlertRule)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Integer this$isDeleted = this.getIsDeleted();
        Integer other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$auditId = this.getAuditId();
        String other$auditId = other.getAuditId();
        if (this$auditId == null ? other$auditId != null : !this$auditId.equals(other$auditId)) {
            return false;
        }
        String this$alertName = this.getAlertName();
        String other$alertName = other.getAlertName();
        if (this$alertName == null ? other$alertName != null : !this$alertName.equals(other$alertName)) {
            return false;
        }
        AuditAlertCondition this$condition = this.getCondition();
        AuditAlertCondition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$notifyType = this.getNotifyType();
        String other$notifyType = other.getNotifyType();
        if (this$notifyType == null ? other$notifyType != null : !this$notifyType.equals(other$notifyType)) {
            return false;
        }
        String this$receivers = this.getReceivers();
        String other$receivers = other.getReceivers();
        if (this$receivers == null ? other$receivers != null : !this$receivers.equals(other$receivers)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        return !(this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditAlertRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Integer $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $auditId = this.getAuditId();
        result = result * 59 + ($auditId == null ? 43 : $auditId.hashCode());
        String $alertName = this.getAlertName();
        result = result * 59 + ($alertName == null ? 43 : $alertName.hashCode());
        AuditAlertCondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $notifyType = this.getNotifyType();
        result = result * 59 + ($notifyType == null ? 43 : $notifyType.hashCode());
        String $receivers = this.getReceivers();
        result = result * 59 + ($receivers == null ? 43 : $receivers.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        return result;
    }

    public String toString() {
        return "AuditAlertRule(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", auditId=" + this.getAuditId() + ", alertName=" + this.getAlertName() + ", condition=" + this.getCondition() + ", level=" + this.getLevel() + ", notifyType=" + this.getNotifyType() + ", receivers=" + this.getReceivers() + ", enabled=" + this.getEnabled() + ", isDeleted=" + this.getIsDeleted() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", version=" + this.getVersion() + ")";
    }
}

