/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.channel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.AbstractChannelSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverChannelSelector
extends AbstractChannelSelector {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverChannelSelector.class);
    private static final String MASTER_CHANNEL = "master";
    private int masterIndex = 0;
    private int slaveIndex = 0;
    private final List<Channel> masterChannels = new ArrayList<Channel>();
    private final List<Channel> slaveChannels = new ArrayList<Channel>();

    public List<Channel> getRequiredChannels(Event event) {
        ArrayList<Channel> retChannels = new ArrayList<Channel>();
        if (this.masterChannels.size() > 0) {
            retChannels.add(this.masterChannels.get(this.masterIndex));
            this.masterIndex = (this.masterIndex + 1) % this.masterChannels.size();
        } else {
            LOG.warn("masterChannels size is zero!");
        }
        return retChannels;
    }

    public List<Channel> getOptionalChannels(Event event) {
        ArrayList<Channel> retChannels = new ArrayList<Channel>();
        if (this.slaveChannels.size() > 0) {
            retChannels.add(this.slaveChannels.get(this.slaveIndex));
            this.slaveIndex = (this.slaveIndex + 1) % this.slaveChannels.size();
        } else {
            LOG.warn("slaveChannels size is zero!");
        }
        return retChannels;
    }

    private List<String> splitChannelName(String channelName) {
        List<String> fileMetricList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)channelName)) {
            LOG.info("channel name is null!");
        } else {
            fileMetricList = Arrays.asList(channelName.split("\\s+"));
        }
        return fileMetricList;
    }

    public void configure(Context context) {
        String masters = context.getString(MASTER_CHANNEL);
        if (StringUtils.isEmpty((CharSequence)masters)) {
            throw new FlumeException("master channel is null!");
        }
        List<String> masterList = this.splitChannelName(masters);
        for (Map.Entry entry : this.getChannelNameMap().entrySet()) {
            String channelName = (String)entry.getKey();
            Channel channel = (Channel)entry.getValue();
            if (masterList.contains(channelName)) {
                this.masterChannels.add(channel);
                continue;
            }
            this.slaveChannels.add(channel);
        }
        LOG.info("masters:" + this.masterChannels);
        LOG.info("slaves:" + this.slaveChannels);
    }
}

