/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.common.metric.MetricItemValue;
import org.apache.inlong.common.metric.MetricListener;
import org.apache.inlong.common.metric.MetricValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentPrometheusMetricListener
extends Collector
implements MetricListener {
    public static final String DEFAULT_DIMENSION_LABEL = "dimension";
    public static final String HYPHEN_SYMBOL = "-";
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentPrometheusMetricListener.class);
    protected HTTPServer httpServer;
    private AgentMetricItem metricItem;
    private Map<String, AtomicLong> metricValueMap = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, MetricItemValue> dimensionMetricValueMap = new ConcurrentHashMap<String, MetricItemValue>();
    private List<String> dimensionKeys = new ArrayList<String>();

    public AgentPrometheusMetricListener() {
        this.metricItem = new AgentMetricItem();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        StringBuilder beanName = new StringBuilder();
        beanName.append("org.apache.inlong").append(':').append("type=AgentPrometheus");
        String strBeanName = beanName.toString();
        try {
            ObjectName objName = new ObjectName(strBeanName);
            mbs.registerMBean((Object)this.metricItem, objName);
        }
        catch (Exception ex) {
            LOGGER.error("exception while register mbean:{},error:{}", (Object)strBeanName, (Object)ex);
        }
        this.metricValueMap.put("jobRunningCount", this.metricItem.jobRunningCount);
        this.metricValueMap.put("jobFatalCount", this.metricItem.jobFatalCount);
        this.metricValueMap.put("taskRunningCount", this.metricItem.taskRunningCount);
        this.metricValueMap.put("taskRetryingCount", this.metricItem.taskRetryingCount);
        this.metricValueMap.put("taskFatalCount", this.metricItem.taskFatalCount);
        this.metricValueMap.put("sinkSuccessCount", this.metricItem.sinkSuccessCount);
        this.metricValueMap.put("sinkFailCount", this.metricItem.sinkFailCount);
        this.metricValueMap.put("sourceSuccessCount", this.metricItem.sourceSuccessCount);
        this.metricValueMap.put("sourceFailCount", this.metricItem.sourceFailCount);
        this.metricValueMap.put("pluginReadCount", this.metricItem.pluginReadCount);
        this.metricValueMap.put("pluginSendCount", this.metricItem.pluginSendCount);
        this.metricValueMap.put("pluginReadFailCount", this.metricItem.pluginReadFailCount);
        this.metricValueMap.put("pluginSendFailCount", this.metricItem.pluginSendFailCount);
        this.metricValueMap.put("pluginReadSuccessCount", this.metricItem.pluginReadSuccessCount);
        this.metricValueMap.put("pluginSendSuccessCount", this.metricItem.pluginSendSuccessCount);
        int metricsServerPort = AgentConfiguration.getAgentConf().getInt("agent.prometheus.exporter.port", 8080);
        try {
            this.httpServer = new HTTPServer(metricsServerPort);
            this.register();
            LOGGER.info("Starting prometheus metrics server on port {}", (Object)metricsServerPort);
        }
        catch (IOException e) {
            LOGGER.error("exception while register agent prometheus http server,error:{}", (Object)e.getMessage());
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        DefaultExports.initialize();
        CounterMetricFamily totalCounter = new CounterMetricFamily("agent", "metrics_of_agent_node_total", Arrays.asList(DEFAULT_DIMENSION_LABEL));
        totalCounter.addMetric(Arrays.asList("jobRunningCount"), (double)this.metricItem.jobRunningCount.get());
        totalCounter.addMetric(Arrays.asList("jobFatalCount"), (double)this.metricItem.jobFatalCount.get());
        totalCounter.addMetric(Arrays.asList("taskRunningCount"), (double)this.metricItem.taskRunningCount.get());
        totalCounter.addMetric(Arrays.asList("taskRetryingCount"), (double)this.metricItem.taskRetryingCount.get());
        totalCounter.addMetric(Arrays.asList("taskFatalCount"), (double)this.metricItem.taskFatalCount.get());
        totalCounter.addMetric(Arrays.asList("sinkSuccessCount"), (double)this.metricItem.sinkSuccessCount.get());
        totalCounter.addMetric(Arrays.asList("sinkFailCount"), (double)this.metricItem.sinkFailCount.get());
        totalCounter.addMetric(Arrays.asList("sourceSuccessCount"), (double)this.metricItem.sourceSuccessCount.get());
        totalCounter.addMetric(Arrays.asList("sourceFailCount"), (double)this.metricItem.sourceFailCount.get());
        totalCounter.addMetric(Arrays.asList("pluginReadCount"), (double)this.metricItem.pluginReadCount.get());
        totalCounter.addMetric(Arrays.asList("pluginSendCount"), (double)this.metricItem.pluginSendCount.get());
        totalCounter.addMetric(Arrays.asList("pluginReadFailCount"), (double)this.metricItem.pluginReadFailCount.get());
        totalCounter.addMetric(Arrays.asList("pluginSendFailCount"), (double)this.metricItem.pluginSendFailCount.get());
        totalCounter.addMetric(Arrays.asList("pluginReadSuccessCount"), (double)this.metricItem.pluginReadSuccessCount.get());
        totalCounter.addMetric(Arrays.asList("pluginSendSuccessCount"), (double)this.metricItem.pluginSendSuccessCount.get());
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        mfs.add((Collector.MetricFamilySamples)totalCounter);
        for (Map.Entry<String, MetricItemValue> entry : this.dimensionMetricValueMap.entrySet()) {
            MetricItemValue itemValue = entry.getValue();
            Map dimensionMap = itemValue.getDimensions();
            String pluginId = dimensionMap.getOrDefault("pluginId", HYPHEN_SYMBOL);
            String componentName = dimensionMap.getOrDefault("componentName", HYPHEN_SYMBOL);
            String counterName = pluginId.equals(HYPHEN_SYMBOL) ? componentName : pluginId;
            ArrayList<String> dimensionIdKeys = new ArrayList<String>();
            dimensionIdKeys.add(DEFAULT_DIMENSION_LABEL);
            dimensionIdKeys.addAll(dimensionMap.keySet());
            CounterMetricFamily idCounter = new CounterMetricFamily(counterName, "metrics_of_agent_dimensions_" + counterName, dimensionIdKeys);
            this.addCounterMetricFamily("jobRunningCount", itemValue, idCounter);
            this.addCounterMetricFamily("jobFatalCount", itemValue, idCounter);
            this.addCounterMetricFamily("taskRunningCount", itemValue, idCounter);
            this.addCounterMetricFamily("taskRetryingCount", itemValue, idCounter);
            this.addCounterMetricFamily("taskFatalCount", itemValue, idCounter);
            this.addCounterMetricFamily("sinkSuccessCount", itemValue, idCounter);
            this.addCounterMetricFamily("sinkFailCount", itemValue, idCounter);
            this.addCounterMetricFamily("sourceSuccessCount", itemValue, idCounter);
            this.addCounterMetricFamily("sourceFailCount", itemValue, idCounter);
            this.addCounterMetricFamily("pluginReadCount", itemValue, idCounter);
            this.addCounterMetricFamily("pluginSendCount", itemValue, idCounter);
            this.addCounterMetricFamily("pluginReadFailCount", itemValue, idCounter);
            this.addCounterMetricFamily("pluginSendFailCount", itemValue, idCounter);
            this.addCounterMetricFamily("pluginReadSuccessCount", itemValue, idCounter);
            this.addCounterMetricFamily("pluginSendSuccessCount", itemValue, idCounter);
            mfs.add((Collector.MetricFamilySamples)idCounter);
        }
        return mfs;
    }

    public void snapshot(String domain, List<MetricItemValue> itemValues) {
        for (MetricItemValue itemValue : itemValues) {
            for (Map.Entry entry : itemValue.getMetrics().entrySet()) {
                String fieldName = ((MetricValue)entry.getValue()).name;
                AtomicLong metricValue = this.metricValueMap.get(fieldName);
                if (metricValue == null) continue;
                long fieldValue = ((MetricValue)entry.getValue()).value;
                metricValue.addAndGet(fieldValue);
            }
            String dimensionKey = itemValue.getKey();
            MetricItemValue dimensionMetricValue = this.dimensionMetricValueMap.get(dimensionKey);
            if (dimensionMetricValue == null) {
                dimensionMetricValue = new MetricItemValue(dimensionKey, new ConcurrentHashMap(), new ConcurrentHashMap());
                this.dimensionMetricValueMap.putIfAbsent(dimensionKey, dimensionMetricValue);
                dimensionMetricValue = this.dimensionMetricValueMap.get(dimensionKey);
                dimensionMetricValue.getDimensions().putAll(itemValue.getDimensions());
                for (Map.Entry entry : itemValue.getDimensions().entrySet()) {
                    if (this.dimensionKeys.contains(entry.getKey())) continue;
                    this.dimensionKeys.add((String)entry.getKey());
                }
            }
            for (Map.Entry entry : itemValue.getMetrics().entrySet()) {
                String fieldName = ((MetricValue)entry.getValue()).name;
                MetricValue metricValue = (MetricValue)dimensionMetricValue.getMetrics().get(fieldName);
                if (metricValue == null) {
                    metricValue = MetricValue.of((String)fieldName, (long)((MetricValue)entry.getValue()).value);
                    dimensionMetricValue.getMetrics().put(metricValue.name, metricValue);
                    continue;
                }
                metricValue.value += ((MetricValue)entry.getValue()).value;
            }
        }
    }

    private void addCounterMetricFamily(String defaultDimension, MetricItemValue itemValue, CounterMetricFamily idCounter) {
        Map dimensionMap = itemValue.getDimensions();
        ArrayList<String> labelValues = new ArrayList<String>(dimensionMap.size() + 1);
        labelValues.add(defaultDimension);
        for (String key : dimensionMap.keySet()) {
            String labelValue = dimensionMap.getOrDefault(key, HYPHEN_SYMBOL);
            labelValues.add(labelValue);
        }
        long value = 0L;
        Map metricValueMap = itemValue.getMetrics();
        MetricValue metricValue = (MetricValue)metricValueMap.get(defaultDimension);
        if (metricValue != null) {
            value = metricValue.value;
        }
        idCounter.addMetric(labelValues, (double)value);
    }
}

