/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.store;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.store.KeyValueEntity;
import org.apache.inlong.agent.store.Store;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceStore.class);
    private final Store store;

    public InstanceStore(Store store) {
        this.store = store;
    }

    public List<InstanceProfile> listAllInstances() {
        List<KeyValueEntity> result = this.store.findAll(this.store.getUniqueKey());
        ArrayList<InstanceProfile> instanceList = new ArrayList<InstanceProfile>();
        for (KeyValueEntity entity : result) {
            instanceList.add(entity.getAsInstanceProfile());
        }
        return instanceList;
    }

    public int getRunningInstanceCount() {
        List<KeyValueEntity> result = this.store.findAll(this.store.getUniqueKey());
        int count = 0;
        for (KeyValueEntity entity : result) {
            if (entity.getAsInstanceProfile().getState() != InstanceStateEnum.DEFAULT) continue;
            ++count;
        }
        return count;
    }

    public List<InstanceProfile> getInstances(String taskId) {
        List<KeyValueEntity> result = this.store.findAll(this.getKeyByTaskId(taskId) + this.store.getSplitter());
        ArrayList<InstanceProfile> instanceList = new ArrayList<InstanceProfile>();
        for (KeyValueEntity entity : result) {
            instanceList.add(entity.getAsInstanceProfile());
        }
        return instanceList;
    }

    public void storeInstance(InstanceProfile instance) {
        if (instance.allRequiredKeyExist()) {
            String keyName = this.getKeyByTaskAndInstanceId(instance.get("task.id"), instance.get("instance.id"));
            KeyValueEntity entity = new KeyValueEntity(keyName, instance.toJsonStr(), instance.get("instance.id"));
            this.store.put(entity);
        } else {
            LOGGER.error("instance profile invalid!");
        }
    }

    public InstanceProfile getInstance(String taskId, String instanceId) {
        KeyValueEntity result = this.store.get(this.getKeyByTaskAndInstanceId(taskId, instanceId));
        if (result == null) {
            return null;
        }
        return result.getAsInstanceProfile();
    }

    public void deleteInstance(String taskId, String instanceId) {
        this.store.remove(this.getKeyByTaskAndInstanceId(taskId, instanceId));
    }

    public String getKey() {
        if (this.store.getUniqueKey().isEmpty()) {
            return "ins" + this.store.getSplitter();
        }
        return this.store.getUniqueKey() + this.store.getSplitter() + "ins" + this.store.getSplitter();
    }

    public String getKeyByTaskId(String taskId) {
        return this.getKey() + taskId;
    }

    public String getKeyByTaskAndInstanceId(String taskId, String instanceId) {
        return this.getKeyByTaskId(taskId) + this.store.getSplitter() + this.store.replaceKeywords(instanceId);
    }
}

