/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.GridCache;
import org.apache.ignite.cache.spring.SpringCache;
import org.apache.ignite.cache.spring.SpringCacheManager;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateAdapter;
import org.apache.ignite.internal.processors.cache.CacheEntrySerializablePredicate;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheProjectionEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtilityKey;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.springframework.cache.Cache;

public class SpringDynamicCacheManager
extends SpringCacheManager {
    private String dataCacheName;
    private GridCacheProjectionEx<MetaKey, Cache> metaCache;
    private GridCache<DataKey, Object> dataCache;

    public String getDataCacheName() {
        return this.dataCacheName;
    }

    public void setDataCacheName(String dataCacheName) {
        this.dataCacheName = dataCacheName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.metaCache = ((IgniteEx)this.grid).utilityCache(MetaKey.class, Cache.class);
        this.dataCache = ((IgniteKernal)this.grid).cache(this.dataCacheName);
    }

    @Override
    public Cache getCache(String name) {
        Cache cache = super.getCache(name);
        if (cache != null) {
            return cache;
        }
        try {
            Cache old;
            MetaKey key = new MetaKey(name);
            cache = (Cache)this.metaCache.get((Object)key);
            if (cache == null && (old = (Cache)this.metaCache.putIfAbsent((Object)key, (Object)(cache = new SpringCache(name, this.grid, this.dataCache.projection((CacheEntryPredicate)new CacheEntrySerializablePredicate((CacheEntryPredicate)new ProjectionFilter(name))), new DataKeyFactory(name))))) != null) {
                cache = old;
            }
            return cache;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    @Override
    public Collection<String> getCacheNames() {
        Collection names = F.view(super.getCacheNames(), (IgnitePredicate[])new IgnitePredicate[]{new IgnitePredicate<String>(){

            public boolean apply(String name) {
                return !F.eq((Object)name, (Object)SpringDynamicCacheManager.this.dataCacheName);
            }
        }});
        return F.concat((boolean)false, (Collection)names, (Collection)F.transform((Collection)this.metaCache.entrySetx(new CacheEntryPredicate[0]), (IgniteClosure)new IgniteClosure<Cache.Entry<MetaKey, Cache>, String>(){

            public String apply(Cache.Entry<MetaKey, Cache> e) {
                return ((MetaKey)e.getKey()).name;
            }
        }));
    }

    private static class ProjectionFilter
    extends CacheEntryPredicateAdapter
    implements Externalizable {
        private String name;

        public ProjectionFilter() {
        }

        private ProjectionFilter(String name) {
            this.name = name;
        }

        public boolean apply(GridCacheEntryEx e) {
            DataKey key = (DataKey)e.key().value(e.context().cacheObjectContext(), false);
            return this.name != null ? this.name.equals(key.name) : key.name == null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString((DataInput)in);
        }

        public String toString() {
            return S.toString(ProjectionFilter.class, (Object)this);
        }
    }

    private static class DataKey
    implements Externalizable {
        private String name;
        @GridToStringInclude
        private Object key;

        private DataKey(String name, Object key) {
            this.name = name;
            this.key = key;
        }

        public DataKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataKey key0 = (DataKey)o;
            return this.name != null ? this.name.equals(key0.name) : (key0.name == null && this.key != null ? this.key.equals(key0.key) : key0.key == null);
        }

        public int hashCode() {
            int res = this.name != null ? this.name.hashCode() : 0;
            res = 31 * res + (this.key != null ? this.key.hashCode() : 0);
            return res;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.name);
            out.writeObject(this.key);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString((DataInput)in);
            this.key = in.readObject();
        }

        public String toString() {
            return S.toString(DataKey.class, (Object)this);
        }
    }

    private static class MetaKey
    extends GridCacheUtilityKey<MetaKey>
    implements Externalizable {
        private String name;

        public MetaKey() {
        }

        private MetaKey(String name) {
            this.name = name;
        }

        protected boolean equalsx(MetaKey key) {
            return this.name != null ? this.name.equals(key.name) : key.name == null;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString((DataOutput)out, (String)this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString((DataInput)in);
        }

        public String toString() {
            return S.toString(MetaKey.class, (Object)this);
        }
    }

    private static class DataKeyFactory
    implements IgniteClosure<Object, Object> {
        private String name;

        public DataKeyFactory(String name) {
            this.name = name;
        }

        public Object apply(Object o) {
            return new DataKey(this.name, o);
        }
    }
}

