/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.util.Collection;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.GridCache;
import org.apache.ignite.cache.spring.SpringCache;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.CacheProjection;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpringCacheManager
implements CacheManager,
InitializingBean {
    private String cfgPath;
    private IgniteConfiguration cfg;
    private String gridName;
    protected Ignite grid;

    public String getConfigurationPath() {
        return this.cfgPath;
    }

    public void setConfigurationPath(String cfgPath) {
        this.cfgPath = cfgPath;
    }

    public IgniteConfiguration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(IgniteConfiguration cfg) {
        this.cfg = cfg;
    }

    public String getGridName() {
        return this.gridName;
    }

    public void setGridName(String gridName) {
        this.gridName = gridName;
    }

    public void afterPropertiesSet() throws Exception {
        assert (this.grid == null);
        if (this.cfgPath != null && this.cfg != null) {
            throw new IllegalArgumentException("Both 'configurationPath' and 'configuration' are provided. Set only one of these properties if you need to start a Ignite node inside of GridSpringCacheManager. If you already have a node running, omit both of them and set'gridName' property.");
        }
        this.grid = this.cfgPath != null ? Ignition.start((String)this.cfgPath) : (this.cfg != null ? Ignition.start((IgniteConfiguration)this.cfg) : Ignition.ignite((String)this.gridName));
    }

    public Cache getCache(String name) {
        assert (this.grid != null);
        try {
            return new SpringCache(name, this.grid, (CacheProjection<?, ?>)((IgniteKernal)this.grid).cache(name), null);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public Collection<String> getCacheNames() {
        assert (this.grid != null);
        return F.viewReadOnly((Collection)((IgniteKernal)this.grid).caches(), (IgniteClosure)new IgniteClosure<GridCache<?, ?>, String>(){

            public String apply(GridCache<?, ?> c) {
                return c.name();
            }
        }, (IgnitePredicate[])new IgnitePredicate[0]);
    }
}

