/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheProjection;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteRunnable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

class SpringCache
implements Cache,
Serializable {
    private String name;
    private Ignite ignite;
    private CacheProjection<Object, Object> cache;
    private IgniteClosure<Object, Object> keyFactory;

    SpringCache(String name, Ignite ignite, CacheProjection<?, ?> cache, IgniteClosure<Object, Object> keyFactory) {
        assert (cache != null);
        this.name = name;
        this.ignite = ignite;
        this.cache = cache;
        this.keyFactory = keyFactory != null ? keyFactory : F.identity();
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.cache;
    }

    public Cache.ValueWrapper get(Object key) {
        try {
            Object val = this.cache.get(this.keyFactory.apply(key));
            return val != null ? new SimpleValueWrapper(val) : null;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to get value from cache [cacheName=" + this.cache.name() + ", key=" + key + ']', (Throwable)e);
        }
    }

    public <T> T get(Object key, Class<T> type) {
        try {
            Object val = this.cache.get(this.keyFactory.apply(key));
            if (val != null && type != null && !type.isInstance(val)) {
                throw new IllegalStateException("Cached value is not of required type [cacheName=" + this.cache.name() + ", key=" + key + ", val=" + val + ", requiredType=" + type + ']');
            }
            return (T)val;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to get value from cache [cacheName=" + this.cache.name() + ", key=" + key + ']', (Throwable)e);
        }
    }

    public void put(Object key, Object val) {
        try {
            this.cache.putx(this.keyFactory.apply(key), val, new CacheEntryPredicate[0]);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to put value to cache [cacheName=" + this.cache.name() + ", key=" + key + ", val=" + val + ']', (Throwable)e);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object val) {
        try {
            Object old = this.cache.putIfAbsent(this.keyFactory.apply(key), val);
            return old != null ? new SimpleValueWrapper(old) : null;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to put value to cache [cacheName=" + this.cache.name() + ", key=" + key + ", val=" + val + ']', (Throwable)e);
        }
    }

    public void evict(Object key) {
        try {
            this.cache.removex(this.keyFactory.apply(key), new CacheEntryPredicate[0]);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to remove value from cache [cacheName=" + this.cache.name() + ", key=" + key + ']', (Throwable)e);
        }
    }

    public void clear() {
        try {
            this.ignite.compute(this.cache.gridProjection()).broadcast((IgniteRunnable)new ClearClosure(this.cache));
        }
        catch (IgniteException e) {
            throw new IgniteException("Failed to clear cache [cacheName=" + this.cache.name() + ']', (Throwable)e);
        }
    }

    private static class ClearClosure
    extends CAX
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private CacheProjection<Object, Object> cache;

        public ClearClosure() {
        }

        private ClearClosure(CacheProjection<Object, Object> cache) {
            this.cache = cache;
        }

        public void applyx() throws IgniteCheckedException {
            this.cache.localRemoveAll();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.cache);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cache = (CacheProjection)in.readObject();
        }
    }
}

