/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommandBuilder;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class UpdateAllCommandDeserializer
implements MessageDeserializer<UpdateAllCommand> {
    private final UpdateAllCommandBuilder msg;

    UpdateAllCommandDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.updateAllCommand();
    }

    public Class<UpdateAllCommand> klass() {
        return UpdateAllCommand.class;
    }

    public UpdateAllCommand getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readBoxedLong("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.leaseStartTime((Long)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readMap("messageRowsToUpdate", MessageCollectionItemType.UUID, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.messageRowsToUpdate((Map<UUID, TimedBinaryRowMessage>)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = (TablePartitionIdMessage)reader.readMessage("tablePartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tablePartitionId((TablePartitionIdMessage)tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txCoordinatorId((UUID)tmp);
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(UpdateAllCommand.class);
    }
}

