/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.structures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.DatasetRow;
import org.apache.ignite.ml.structures.FeatureMetadata;

public class Dataset<Row extends DatasetRow>
implements Externalizable {
    protected Row[] data;
    protected FeatureMetadata[] meta;
    protected int rowSize;
    protected int colSize;

    public Dataset() {
    }

    public Dataset(Row[] data, FeatureMetadata[] meta) {
        this.data = data;
        this.meta = meta;
    }

    public Dataset(Row[] data, String[] featureNames, int colSize) {
        this(data.length, colSize, featureNames);
        assert (data != null);
        this.data = data;
    }

    public Dataset(Row[] data, int colSize) {
        this((DatasetRow[])data, null, colSize);
    }

    public Dataset(Row[] data) {
        this.data = data;
        this.rowSize = data.length;
    }

    public Dataset(int rowSize, int colSize, String[] featureNames) {
        assert (rowSize > 0);
        assert (colSize > 0);
        if (featureNames == null) {
            this.generateFeatureNames();
        } else {
            assert (colSize == featureNames.length);
            this.convertStringNamesToFeatureMetadata(featureNames);
        }
        this.rowSize = rowSize;
        this.colSize = colSize;
    }

    protected void convertStringNamesToFeatureMetadata(String[] featureNames) {
        this.meta = new FeatureMetadata[featureNames.length];
        for (int i = 0; i < featureNames.length; ++i) {
            this.meta[i] = new FeatureMetadata(featureNames[i]);
        }
    }

    protected void generateFeatureNames() {
        String[] featureNames = new String[this.colSize];
        for (int i = 0; i < this.colSize; ++i) {
            featureNames[i] = "f_" + i;
        }
        this.convertStringNamesToFeatureMetadata(featureNames);
    }

    public String getFeatureName(int i) {
        return this.meta[i].name();
    }

    public DatasetRow[] data() {
        return this.data;
    }

    public void setData(Row[] data) {
        this.data = data;
    }

    public FeatureMetadata[] meta() {
        return this.meta;
    }

    public void setMeta(FeatureMetadata[] meta) {
        this.meta = meta;
    }

    public int colSize() {
        return this.colSize;
    }

    public int rowSize() {
        return this.rowSize;
    }

    public Row getRow(int idx) {
        return this.data[idx];
    }

    public Vector features(int idx) {
        assert (idx < this.rowSize);
        assert (this.data != null);
        assert (this.data[idx] != null);
        return ((DatasetRow)this.data[idx]).features();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dataset that = (Dataset)o;
        return this.rowSize == that.rowSize && this.colSize == that.colSize && Arrays.equals(this.data, that.data) && Arrays.equals(this.meta, that.meta);
    }

    public int hashCode() {
        int res = Arrays.hashCode(this.data);
        res = 31 * res + Arrays.hashCode(this.meta);
        res = 31 * res + this.rowSize;
        res = 31 * res + this.colSize;
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.data);
        out.writeObject(this.meta);
        out.writeInt(this.rowSize);
        out.writeInt(this.colSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.data = (DatasetRow[])in.readObject();
        this.meta = (FeatureMetadata[])in.readObject();
        this.rowSize = in.readInt();
        this.colSize = in.readInt();
    }
}

