/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.BinaryClassificationPointwiseMetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetric;

public class Fdr<L extends Serializable>
extends BinaryClassificationMetric<L> {
    private static final long serialVersionUID = 1246865138630168628L;
    private Double value = Double.NaN;

    public Fdr() {
    }

    public Fdr(L truthLabel, L falseLabel) {
        super(truthLabel, falseLabel);
    }

    public Fdr<L> initBy(BinaryClassificationPointwiseMetricStatsAggregator<L> aggr) {
        int positivePredictions = aggr.getFalsePositive() + aggr.getTruePositive();
        this.value = positivePredictions == 0 ? 1.0 : (double)aggr.getTruePositive() / (double)positivePredictions;
        return this;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public MetricName name() {
        return MetricName.FDR;
    }
}

