/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric;

import org.apache.ignite.ml.selection.scoring.metric.Metric;
import org.apache.ignite.ml.selection.scoring.metric.classification.Accuracy;
import org.apache.ignite.ml.selection.scoring.metric.classification.BalancedAccuracy;
import org.apache.ignite.ml.selection.scoring.metric.classification.FMeasure;
import org.apache.ignite.ml.selection.scoring.metric.classification.FallOut;
import org.apache.ignite.ml.selection.scoring.metric.classification.FalseNegativeAbsoluteValue;
import org.apache.ignite.ml.selection.scoring.metric.classification.FalsePositiveAbsoluteValue;
import org.apache.ignite.ml.selection.scoring.metric.classification.Fdr;
import org.apache.ignite.ml.selection.scoring.metric.classification.MissRate;
import org.apache.ignite.ml.selection.scoring.metric.classification.Npv;
import org.apache.ignite.ml.selection.scoring.metric.classification.Precision;
import org.apache.ignite.ml.selection.scoring.metric.classification.Recall;
import org.apache.ignite.ml.selection.scoring.metric.classification.Specificity;
import org.apache.ignite.ml.selection.scoring.metric.classification.TrueNegativeAbsoluteValue;
import org.apache.ignite.ml.selection.scoring.metric.classification.TruePositiveAbsoluteValue;
import org.apache.ignite.ml.selection.scoring.metric.regression.Mae;
import org.apache.ignite.ml.selection.scoring.metric.regression.Mse;
import org.apache.ignite.ml.selection.scoring.metric.regression.R2;
import org.apache.ignite.ml.selection.scoring.metric.regression.Rmse;
import org.apache.ignite.ml.selection.scoring.metric.regression.Rss;

public enum MetricName {
    ACCURACY("Accuracy"),
    PRECISION("Precision"),
    RECALL("Recall"),
    F_MEASURE("F-measure"),
    TRUE_POSITIVE("TP"),
    TRUE_NEGATIVE("TN"),
    FALSE_NEGATIVE("FN"),
    FALSE_POSITIVE("FP"),
    SPECIFICITY("Specificity"),
    NPV("NPV"),
    FALL_OUT("Fall out"),
    FDR("FDR"),
    MISS_RATE("Miss rate"),
    BALANCED_ACCURACY("Balanced accuracy"),
    MAE("MAE"),
    R2("R2"),
    RMSE("RMSE"),
    RSS("RSS"),
    MSE("MSE");

    private final String prettyName;

    private MetricName(String prettyName) {
        this.prettyName = prettyName;
    }

    public Metric create() {
        switch (this) {
            case ACCURACY: {
                return new Accuracy();
            }
            case PRECISION: {
                return new Precision();
            }
            case RECALL: {
                return new Recall();
            }
            case F_MEASURE: {
                return new FMeasure();
            }
            case MSE: {
                return new Mse();
            }
            case MAE: {
                return new Mae();
            }
            case R2: {
                return new R2();
            }
            case RMSE: {
                return new Rmse();
            }
            case RSS: {
                return new Rss();
            }
            case TRUE_POSITIVE: {
                return new TruePositiveAbsoluteValue();
            }
            case TRUE_NEGATIVE: {
                return new TrueNegativeAbsoluteValue();
            }
            case FALSE_POSITIVE: {
                return new FalsePositiveAbsoluteValue();
            }
            case FALSE_NEGATIVE: {
                return new FalseNegativeAbsoluteValue();
            }
            case SPECIFICITY: {
                return new Specificity();
            }
            case FALL_OUT: {
                return new FallOut();
            }
            case BALANCED_ACCURACY: {
                return new BalancedAccuracy();
            }
            case FDR: {
                return new Fdr();
            }
            case MISS_RATE: {
                return new MissRate();
            }
            case NPV: {
                return new Npv();
            }
        }
        throw new IllegalArgumentException("Cannot define metric by name: " + this.name());
    }

    public String getPrettyName() {
        return this.prettyName;
    }
}

