/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.cursor;

import java.util.Iterator;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.selection.scoring.LabelPair;
import org.apache.ignite.ml.selection.scoring.cursor.LabelPairCursor;
import org.apache.ignite.ml.structures.LabeledVector;
import org.jetbrains.annotations.NotNull;

public class CacheBasedLabelPairCursor<L, K, V>
implements LabelPairCursor<L> {
    private final QueryCursor<Cache.Entry<K, V>> cursor;
    private final Preprocessor<K, V> preprocessor;
    private final IgniteModel<Vector, L> mdl;

    public CacheBasedLabelPairCursor(IgniteCache<K, V> upstreamCache, IgniteBiPredicate<K, V> filter, Preprocessor<K, V> preprocessor, IgniteModel<Vector, L> mdl) {
        this.cursor = this.query(upstreamCache, filter);
        this.preprocessor = preprocessor;
        this.mdl = mdl;
    }

    public CacheBasedLabelPairCursor(IgniteCache<K, V> upstreamCache, Preprocessor<K, V> preprocessor, IgniteModel<Vector, L> mdl) {
        this.cursor = this.query(upstreamCache);
        this.preprocessor = preprocessor;
        this.mdl = mdl;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    @NotNull
    public Iterator<LabelPair<L>> iterator() {
        return new TruthWithPredictionIterator(this.cursor.iterator());
    }

    private QueryCursor<Cache.Entry<K, V>> query(IgniteCache<K, V> upstreamCache, IgniteBiPredicate<K, V> filter) {
        ScanQuery qry = new ScanQuery();
        if (filter != null) {
            qry.setFilter(filter);
        }
        return upstreamCache.query((Query)qry);
    }

    private QueryCursor<Cache.Entry<K, V>> query(IgniteCache<K, V> upstreamCache) {
        ScanQuery qry = new ScanQuery();
        return upstreamCache.query((Query)qry);
    }

    private class TruthWithPredictionIterator
    implements Iterator<LabelPair<L>> {
        private final Iterator<Cache.Entry<K, V>> iter;

        public TruthWithPredictionIterator(Iterator<Cache.Entry<K, V>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public LabelPair<L> next() {
            Cache.Entry entry = this.iter.next();
            LabeledVector lv = (LabeledVector)CacheBasedLabelPairCursor.this.preprocessor.apply(entry.getKey(), entry.getValue());
            return new LabelPair(lv.label(), CacheBasedLabelPairCursor.this.mdl.predict(lv.features()));
        }
    }
}

