/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.regressions.linear;

import java.util.Objects;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public final class LinearRegressionModel
implements IgniteModel<Vector, Double>,
Exportable<LinearRegressionModel> {
    private static final long serialVersionUID = -105984600091550226L;
    private final Vector weights;
    private final double intercept;

    public LinearRegressionModel(Vector weights, double intercept) {
        this.weights = weights;
        this.intercept = intercept;
    }

    public Vector getWeights() {
        return this.weights;
    }

    public double getIntercept() {
        return this.intercept;
    }

    @Override
    public Double predict(Vector input) {
        return input.dot(this.weights) + this.intercept;
    }

    @Override
    public <P> void saveModel(Exporter<LinearRegressionModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinearRegressionModel mdl = (LinearRegressionModel)o;
        return Double.compare(mdl.intercept, this.intercept) == 0 && Objects.equals(this.weights, mdl.weights);
    }

    public int hashCode() {
        return Objects.hash(this.weights, this.intercept);
    }

    public String toString() {
        if (this.weights.size() < 10) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.weights.size(); ++i) {
                double nextItem = i == this.weights.size() - 1 ? this.intercept : this.weights.get(i + 1);
                builder.append(String.format("%.4f", Math.abs(this.weights.get(i)))).append("*x").append(i).append(nextItem > 0.0 ? " + " : " - ");
            }
            builder.append(String.format("%.4f", Math.abs(this.intercept)));
            return builder.toString();
        }
        return "LinearRegressionModel [weights=" + this.weights + ", intercept=" + this.intercept + ']';
    }

    @Override
    public String toString(boolean pretty) {
        return this.toString();
    }
}

