/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.encoding.stringencoder;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.math.exceptions.preprocessing.IllegalFeatureTypeException;
import org.apache.ignite.ml.math.exceptions.preprocessing.UnknownCategorialValueException;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.preprocessing.encoding.EncoderPreprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public final class StringEncoderPreprocessor<K, V>
extends EncoderPreprocessor<K, V>
implements DeployableObject {
    private static final long serialVersionUID = 6237712226382623488L;

    public StringEncoderPreprocessor(Map<String, Integer>[] encodingValues, Preprocessor<K, V> basePreprocessor, Set<Integer> handledIndices) {
        super(encodingValues, basePreprocessor, handledIndices);
    }

    @Override
    public LabeledVector apply(K k, V v) {
        LabeledVector tmp = (LabeledVector)this.basePreprocessor.apply(k, v);
        double[] res = new double[tmp.size()];
        for (int i = 0; i < res.length; ++i) {
            Serializable tmpObj = tmp.getRaw(i);
            if (this.handledIndices.contains(i)) {
                if (tmpObj.equals(Double.NaN) && this.encodingValues[i].containsKey("")) {
                    res[i] = ((Integer)this.encodingValues[i].get("")).intValue();
                    continue;
                }
                if (this.encodingValues[i].containsKey(tmpObj)) {
                    res[i] = ((Integer)this.encodingValues[i].get(tmpObj)).intValue();
                    continue;
                }
                throw new UnknownCategorialValueException(tmpObj.toString());
            }
            if (tmpObj instanceof Number) {
                res[i] = (Double)tmpObj;
                continue;
            }
            throw new IllegalFeatureTypeException(tmpObj.getClass(), tmpObj, Double.class);
        }
        return new LabeledVector(VectorUtils.of(res), tmp.label());
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.basePreprocessor);
    }
}

