/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.encoding.label;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.math.exceptions.preprocessing.UnknownCategorialValueException;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.preprocessing.encoding.EncoderPreprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public final class LabelEncoderPreprocessor<K, V>
extends EncoderPreprocessor<K, V>
implements DeployableObject {
    private static final long serialVersionUID = 6237782236382623488L;

    public LabelEncoderPreprocessor(Map<String, Integer> labelFrequencies, Preprocessor<K, V> basePreprocessor) {
        super(labelFrequencies, basePreprocessor);
    }

    @Override
    public LabeledVector apply(K k, V v) {
        double res;
        LabeledVector tmp = (LabeledVector)this.basePreprocessor.apply(k, v);
        Object tmpObj = tmp.label();
        if (tmpObj.equals(Double.NaN) && this.labelFrequencies.containsKey("")) {
            res = ((Integer)this.labelFrequencies.get("")).intValue();
        } else if (this.labelFrequencies.containsKey(tmpObj)) {
            res = ((Integer)this.labelFrequencies.get(tmpObj)).intValue();
        } else {
            throw new UnknownCategorialValueException(tmpObj.toString());
        }
        return new LabeledVector<Double>((Vector)tmp.features(), res);
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.basePreprocessor);
    }
}

