/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing;

import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDatasetBuilder;
import org.apache.ignite.ml.dataset.impl.local.LocalDatasetBuilder;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.preprocessing.Preprocessor;

public interface PreprocessingTrainer<K, V> {
    public Preprocessor<K, V> fit(LearningEnvironmentBuilder var1, DatasetBuilder<K, V> var2, Preprocessor<K, V> var3);

    default public Preprocessor<K, V> fit(DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> basePreprocessor) {
        return this.fit(LearningEnvironmentBuilder.defaultBuilder(), datasetBuilder, basePreprocessor);
    }

    default public Preprocessor<K, V> fit(Ignite ignite, IgniteCache<K, V> cache, Preprocessor<K, V> basePreprocessor) {
        return this.fit(new CacheBasedDatasetBuilder<K, V>(ignite, cache), basePreprocessor);
    }

    default public Preprocessor<K, V> fit(LearningEnvironmentBuilder envBuilder, Ignite ignite, IgniteCache<K, V> cache, Preprocessor<K, V> basePreprocessor) {
        return this.fit(envBuilder, new CacheBasedDatasetBuilder<K, V>(ignite, cache), basePreprocessor);
    }

    default public Preprocessor<K, V> fit(LearningEnvironmentBuilder envBuilder, Map<K, V> data, int parts, Preprocessor<K, V> basePreprocessor) {
        return this.fit(envBuilder, new LocalDatasetBuilder<K, V>(data, parts), basePreprocessor);
    }

    default public Preprocessor<K, V> fit(Map<K, V> data, int parts, Preprocessor<K, V> basePreprocessor) {
        return this.fit(new LocalDatasetBuilder<K, V>(data, parts), basePreprocessor);
    }

    default public LearningEnvironment learningEnvironment(Preprocessor<K, V> basePreprocessor) {
        LearningEnvironment env = LearningEnvironmentBuilder.defaultBuilder().buildForTrainer();
        env.initDeployingContext(basePreprocessor);
        return env;
    }
}

