/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.naivebayes.discrete;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.naivebayes.BayesModel;
import org.apache.ignite.ml.naivebayes.discrete.DiscreteNaiveBayesSumsHolder;

public class DiscreteNaiveBayesModel
implements BayesModel<DiscreteNaiveBayesModel, Vector, Double>,
DeployableObject {
    private static final long serialVersionUID = -127386523291350345L;
    private final double[][][] probabilities;
    private final double[] clsProbabilities;
    private final double[] labels;
    private final double[][] bucketThresholds;
    private final DiscreteNaiveBayesSumsHolder sumsHolder;

    public DiscreteNaiveBayesModel(double[][][] probabilities, double[] clsProbabilities, double[] labels, double[][] bucketThresholds, DiscreteNaiveBayesSumsHolder sumsHolder) {
        this.probabilities = probabilities;
        this.clsProbabilities = clsProbabilities;
        this.labels = labels;
        this.bucketThresholds = bucketThresholds;
        this.sumsHolder = sumsHolder;
    }

    @Override
    public <P> void saveModel(Exporter<DiscreteNaiveBayesModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    @Override
    public Double predict(Vector vector) {
        double[] probapilityPowers = this.probabilityPowers(vector);
        int maxLbIdx = 0;
        for (int i = 0; i < probapilityPowers.length; ++i) {
            int n = i;
            probapilityPowers[n] = probapilityPowers[n] + Math.log(this.clsProbabilities[i]);
            if (!(probapilityPowers[i] > probapilityPowers[maxLbIdx])) continue;
            maxLbIdx = i;
        }
        return this.labels[maxLbIdx];
    }

    @Override
    public double[] probabilityPowers(Vector vector) {
        double[] probapilityPowers = new double[this.clsProbabilities.length];
        for (int i = 0; i < this.clsProbabilities.length; ++i) {
            for (int j = 0; j < this.probabilities[0].length; ++j) {
                int x = this.toBucketNumber(vector.get(j), this.bucketThresholds[j]);
                double p = this.probabilities[i][j][x];
                int n = i;
                probapilityPowers[n] = probapilityPowers[n] + (p > 0.0 ? Math.log(p) : 0.0);
            }
        }
        return probapilityPowers;
    }

    public double[][][] getProbabilities() {
        return this.probabilities;
    }

    public double[] getClsProbabilities() {
        return this.clsProbabilities;
    }

    public double[][] getBucketThresholds() {
        return this.bucketThresholds;
    }

    public double[] getLabels() {
        return this.labels;
    }

    public DiscreteNaiveBayesSumsHolder getSumsHolder() {
        return this.sumsHolder;
    }

    private int toBucketNumber(double val, double[] thresholds) {
        for (int i = 0; i < thresholds.length; ++i) {
            if (!(val < thresholds[i])) continue;
            return i;
        }
        return thresholds.length;
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.emptyList();
    }
}

