/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.matrix.storage;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.primitives.matrix.MatrixStorage;

public class ViewMatrixStorage
implements MatrixStorage {
    private MatrixStorage dlg;
    private int rowOff;
    private int colOff;
    private int rows;
    private int cols;

    public ViewMatrixStorage() {
    }

    public ViewMatrixStorage(MatrixStorage dlg, int rowOff, int colOff, int rows, int cols) {
        assert (dlg != null);
        assert (rowOff >= 0);
        assert (colOff >= 0);
        assert (rows > 0);
        assert (cols > 0);
        this.dlg = dlg;
        this.rowOff = rowOff;
        this.colOff = colOff;
        this.rows = rows;
        this.cols = cols;
    }

    public MatrixStorage delegate() {
        return this.dlg;
    }

    public int rowOffset() {
        return this.rowOff;
    }

    public int columnOffset() {
        return this.colOff;
    }

    public int rowsLength() {
        return this.rows;
    }

    public int columnsLength() {
        return this.cols;
    }

    @Override
    public double get(int x, int y) {
        return this.dlg.get(this.rowOff + x, this.colOff + y);
    }

    @Override
    public void set(int x, int y, double v) {
        this.dlg.set(this.rowOff + x, this.colOff + y, v);
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public int storageMode() {
        return this.dlg.storageMode();
    }

    @Override
    public int accessMode() {
        return this.dlg.accessMode();
    }

    @Override
    public boolean isArrayBased() {
        return this.dlg.isArrayBased() && this.rowOff == 0 && this.colOff == 0;
    }

    @Override
    public boolean isDense() {
        return this.dlg.isDense();
    }

    @Override
    public double[] data() {
        return this.dlg.data();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dlg);
        out.writeInt(this.rowOff);
        out.writeInt(this.colOff);
        out.writeInt(this.rows);
        out.writeInt(this.cols);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dlg = (MatrixStorage)in.readObject();
        this.rowOff = in.readInt();
        this.colOff = in.readInt();
        this.rows = in.readInt();
        this.cols = in.readInt();
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.rows;
        res = res * 37 + this.cols;
        res = res * 37 + this.rowOff;
        res = res * 37 + this.colOff;
        res = res * 37 + this.dlg.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewMatrixStorage that = (ViewMatrixStorage)o;
        return this.rows == that.rows && this.cols == that.cols && this.rowOff == that.rowOff && this.colOff == that.colOff && (this.dlg != null ? this.dlg.equals(that.dlg) : that.dlg == null);
    }
}

