/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distances;

import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class EuclideanDistance
implements DistanceMeasure {
    private static final long serialVersionUID = 1717556319784040040L;

    @Override
    public double compute(Vector a, Vector b) throws CardinalityException {
        return MatrixUtil.localCopyOf(a).minus(b).kNorm(2.0);
    }

    @Override
    public double compute(Vector a, double[] b) throws CardinalityException {
        double res = 0.0;
        for (int i = 0; i < b.length; ++i) {
            res += Math.pow(Math.abs(b[i] - a.get(i)), 2.0);
        }
        return Math.sqrt(res);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

