/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.cache;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamTransformerBuilder;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDataset;
import org.apache.ignite.ml.dataset.impl.cache.util.ComputeUtils;
import org.apache.ignite.ml.dataset.impl.cache.util.DatasetAffinityFunctionWrapper;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;

public class CacheBasedDatasetBuilder<K, V>
implements DatasetBuilder<K, V> {
    public static final int DEFAULT_NUMBER_OF_RETRIES = 900;
    private static final int RETRY_INTERVAL = 1000;
    private static final String DATASET_CACHE_TEMPLATE = "%s_DATASET_%s";
    private final Ignite ignite;
    private final IgniteCache<K, V> upstreamCache;
    private final IgniteBiPredicate<K, V> filter;
    private final UpstreamTransformerBuilder transformerBuilder;
    private final boolean upstreamKeepBinary;
    private final int retries;

    public CacheBasedDatasetBuilder(Ignite ignite, IgniteCache<K, V> upstreamCache) {
        this(ignite, upstreamCache, (IgniteBiPredicate & Serializable)(a, b) -> true);
    }

    public CacheBasedDatasetBuilder(Ignite ignite, IgniteCache<K, V> upstreamCache, IgniteBiPredicate<K, V> filter) {
        this(ignite, upstreamCache, filter, UpstreamTransformerBuilder.identity());
    }

    public CacheBasedDatasetBuilder(Ignite ignite, IgniteCache<K, V> upstreamCache, IgniteBiPredicate<K, V> filter, UpstreamTransformerBuilder transformerBuilder) {
        this(ignite, upstreamCache, filter, transformerBuilder, false, 900);
    }

    public CacheBasedDatasetBuilder(Ignite ignite, IgniteCache<K, V> upstreamCache, IgniteBiPredicate<K, V> filter, UpstreamTransformerBuilder transformerBuilder, Boolean isKeepBinary, int retries) {
        this.ignite = ignite;
        this.upstreamCache = upstreamCache;
        this.filter = filter;
        this.transformerBuilder = transformerBuilder;
        this.upstreamKeepBinary = isKeepBinary;
        this.retries = retries;
    }

    public <C extends Serializable, D extends AutoCloseable> CacheBasedDataset<K, V, C, D> build(LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder, LearningEnvironment localLearningEnv) {
        UUID datasetId = UUID.randomUUID();
        CacheConfiguration upstreamCacheConfiguration = (CacheConfiguration)this.upstreamCache.getConfiguration(CacheConfiguration.class);
        AffinityFunction upstreamCacheAffinity = upstreamCacheConfiguration.getAffinity();
        CacheConfiguration datasetCacheConfiguration = new CacheConfiguration();
        datasetCacheConfiguration.setName(String.format(DATASET_CACHE_TEMPLATE, this.upstreamCache.getName(), datasetId));
        datasetCacheConfiguration.setAffinity((AffinityFunction)new DatasetAffinityFunctionWrapper(upstreamCacheAffinity));
        IgniteCache datasetCache = this.ignite.createCache(datasetCacheConfiguration);
        ComputeUtils.initContext(this.ignite, this.upstreamCache.getName(), this.transformerBuilder, this.filter, datasetCache.getName(), partCtxBuilder, envBuilder, this.retries, 1000, this.upstreamKeepBinary, localLearningEnv.deployingContext());
        return new CacheBasedDataset<K, V, C, D>(this.ignite, this.upstreamCache, this.filter, this.transformerBuilder, datasetCache, envBuilder, partDataBuilder, datasetId, this.upstreamKeepBinary, localLearningEnv, this.retries);
    }

    @Override
    public DatasetBuilder<K, V> withUpstreamTransformer(UpstreamTransformerBuilder builder) {
        return new CacheBasedDatasetBuilder<K, V>(this.ignite, this.upstreamCache, this.filter, this.transformerBuilder.andThen(builder));
    }

    @Override
    public DatasetBuilder<K, V> withFilter(IgniteBiPredicate<K, V> filterToAdd) {
        return new CacheBasedDatasetBuilder<K, V>(this.ignite, this.upstreamCache, (IgniteBiPredicate & Serializable)(e1, e2) -> this.filter.apply(e1, e2) && filterToAdd.apply(e1, e2));
    }

    public CacheBasedDatasetBuilder<K, V> withKeepBinary(boolean isKeepBinary) {
        return new CacheBasedDatasetBuilder<K, V>(this.ignite, this.upstreamCache, this.filter, this.transformerBuilder, isKeepBinary, this.retries);
    }

    public CacheBasedDatasetBuilder<K, V> withRetriesNumber(int retries) {
        return new CacheBasedDatasetBuilder<K, V>(this.ignite, this.upstreamCache, this.filter, this.transformerBuilder, this.upstreamKeepBinary, retries);
    }

    public IgniteCache<K, V> getUpstreamCache() {
        return this.upstreamCache;
    }
}

