/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.log4j2;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.logger.LoggerNodeIdAware;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.jetbrains.annotations.Nullable;

public class Log4J2Logger
implements IgniteLogger,
LoggerNodeIdAware {
    private static final String NODE_ID = "nodeId";
    private static final String CONSOLE_APPENDER = "autoConfiguredIgniteConsoleAppender";
    private static volatile boolean inited;
    private static volatile boolean quiet0;
    private static final Object mux;
    @GridToStringExclude
    private Logger impl;
    @GridToStringExclude
    private Logger consoleLog;
    private final boolean quiet;
    private volatile UUID nodeId;

    private Log4J2Logger(Logger impl, @Nullable Logger consoleLog) {
        assert (impl != null);
        this.impl = impl;
        this.consoleLog = consoleLog;
        this.quiet = quiet0;
    }

    public Log4J2Logger(String path) throws IgniteCheckedException {
        if (path == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j must be specified.");
        }
        final URL cfgUrl = U.resolveIgniteUrl((String)path);
        if (cfgUrl == null) {
            throw new IgniteCheckedException("Log4j configuration path was not found: " + path);
        }
        this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    Configurator.initialize((String)"", (String)cfgUrl.toString());
                }
                return (Logger)LogManager.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public Log4J2Logger(File cfgFile) throws IgniteCheckedException {
        if (cfgFile == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j must be specified.");
        }
        if (!cfgFile.exists() || cfgFile.isDirectory()) {
            throw new IgniteCheckedException("Log4j2 configuration path was not found or is a directory: " + cfgFile);
        }
        final String path = cfgFile.getAbsolutePath();
        this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    Configurator.initialize((String)"", (String)path);
                }
                return (Logger)LogManager.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public Log4J2Logger(final URL cfgUrl) throws IgniteCheckedException {
        if (cfgUrl == null) {
            throw new IgniteCheckedException("Configuration XML file for Log4j must be specified.");
        }
        this.addConsoleAppenderIfNeeded((IgniteClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    Configurator.initialize((String)"", (String)cfgUrl.toString());
                }
                return (Logger)LogManager.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public void setLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration conf = ctx.getConfiguration();
        conf.getLoggerConfig(this.impl.getName()).setLevel(level);
        ctx.updateLoggers(conf);
    }

    @Nullable
    public String fileName() {
        for (Logger log = this.impl; log != null; log = log.getParent()) {
            for (Appender a : log.getAppenders().values()) {
                if (a instanceof FileAppender) {
                    return ((FileAppender)a).getFileName();
                }
                if (a instanceof RollingFileAppender) {
                    return ((RollingFileAppender)a).getFileName();
                }
                if (!(a instanceof RoutingAppender)) continue;
                try {
                    RoutingAppender routing = (RoutingAppender)a;
                    Field appsFiled = routing.getClass().getDeclaredField("appenders");
                    appsFiled.setAccessible(true);
                    Map appenders = (Map)appsFiled.get(routing);
                    for (AppenderControl control : appenders.values()) {
                        Appender innerApp = control.getAppender();
                        if (innerApp instanceof FileAppender) {
                            return this.normilize(((FileAppender)innerApp).getFileName());
                        }
                        if (!(innerApp instanceof RollingFileAppender)) continue;
                        return this.normilize(((RollingFileAppender)innerApp).getFileName());
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    this.error("Failed to get file name (was the implementation of log4j2 changed?).", e);
                }
            }
        }
        return null;
    }

    private String normilize(String path) {
        if (!U.isWindows()) {
            return path;
        }
        return path.replace('/', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsoleAppenderIfNeeded(@Nullable IgniteClosure<Boolean, Logger> initLogClo) {
        if (inited) {
            this.impl = (Logger)initLogClo.apply((Object)false);
            return;
        }
        Object object = mux;
        synchronized (object) {
            if (inited) {
                this.impl = (Logger)initLogClo.apply((Object)false);
                return;
            }
            this.impl = (Logger)initLogClo.apply((Object)true);
            boolean quiet = Boolean.valueOf(System.getProperty("IGNITE_QUIET", "true"));
            boolean consoleAppenderFound = false;
            Logger rootLogger = null;
            for (Logger log = this.impl; log != null; log = log.getParent()) {
                if (!consoleAppenderFound) {
                    for (Appender appender : log.getAppenders().values()) {
                        if (!(appender instanceof ConsoleAppender) || "CONSOLE_ERR".equals(appender.getName())) continue;
                        consoleAppenderFound = true;
                        break;
                    }
                }
                if (log.getParent() != null) continue;
                rootLogger = log;
                break;
            }
            if (consoleAppenderFound && quiet) {
                quiet = false;
            }
            if (!consoleAppenderFound && !quiet && Boolean.valueOf(System.getProperty("IGNITE_CONSOLE_APPENDER", "true")).booleanValue()) {
                assert (rootLogger != null);
                this.consoleLog = Log4J2Logger.createConsoleLogger();
            }
            quiet0 = quiet;
            inited = true;
        }
    }

    public static Logger createConsoleLogger() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)true);
        Configuration cfg = ctx.getConfiguration();
        PatternLayout.Builder builder = PatternLayout.newBuilder();
        builder.withPattern("%d{ISO8601}][%-5p][%t][%c{1}] %m%n").withCharset(Charset.defaultCharset()).withAlwaysWriteExceptions(false).withNoConsoleNoAnsi(false);
        PatternLayout layout = builder.build();
        ConsoleAppender.Builder consoleAppenderBuilder = ConsoleAppender.newBuilder();
        consoleAppenderBuilder.withName(CONSOLE_APPENDER).withLayout((Layout)layout);
        ConsoleAppender consoleApp = consoleAppenderBuilder.build();
        consoleApp.start();
        AppenderRef ref = AppenderRef.createAppenderRef((String)CONSOLE_APPENDER, (Level)Level.TRACE, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig logCfg = LoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)"", (String)"", (AppenderRef[])refs, null, null, null);
        logCfg.addAppender((Appender)consoleApp, null, null);
        cfg.addAppender((Appender)consoleApp);
        cfg.addLogger("", logCfg);
        ctx.updateLoggers(cfg);
        return (Logger)LogManager.getContext().getLogger("");
    }

    public void setNodeId(UUID nodeId) {
        A.notNull((Object)nodeId, (String)NODE_ID);
        this.nodeId = nodeId;
        System.setProperty(NODE_ID, U.id8((UUID)nodeId));
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public Log4J2Logger getLogger(Object ctgr) {
        if (ctgr == null) {
            return new Log4J2Logger((Logger)LogManager.getRootLogger(), this.consoleLog == null ? null : (Logger)LogManager.getContext().getLogger(""));
        }
        if (ctgr instanceof Class) {
            String name = ((Class)ctgr).getName();
            return new Log4J2Logger((Logger)LogManager.getLogger((String)name), this.consoleLog == null ? null : (Logger)LogManager.getContext().getLogger(name));
        }
        String name = ctgr.toString();
        return new Log4J2Logger((Logger)LogManager.getLogger((String)name), this.consoleLog == null ? null : (Logger)LogManager.getContext().getLogger(name));
    }

    public void trace(String msg) {
        if (!this.isTraceEnabled()) {
            this.warning("Logging at TRACE level without checking if TRACE level is enabled: " + msg);
        }
        this.impl.trace(msg);
        if (this.consoleLog != null) {
            this.consoleLog.trace(msg);
        }
    }

    public void debug(String msg) {
        if (!this.isDebugEnabled()) {
            this.warning("Logging at DEBUG level without checking if DEBUG level is enabled: " + msg);
        }
        this.impl.debug(msg);
        if (this.consoleLog != null) {
            this.consoleLog.debug(msg);
        }
    }

    public void info(String msg) {
        if (!this.isInfoEnabled()) {
            this.warning("Logging at INFO level without checking if INFO level is enabled: " + msg);
        }
        this.impl.info(msg);
        if (this.consoleLog != null) {
            this.consoleLog.info(msg);
        }
    }

    public void warning(String msg) {
        this.impl.warn(msg);
        if (this.consoleLog != null) {
            this.consoleLog.warn(msg);
        }
    }

    public void warning(String msg, @Nullable Throwable e) {
        this.impl.warn(msg, e);
        if (this.consoleLog != null) {
            this.consoleLog.warn(msg, e);
        }
    }

    public void error(String msg) {
        this.impl.error(msg);
        if (this.consoleLog != null) {
            this.consoleLog.error(msg);
        }
    }

    public void error(String msg, @Nullable Throwable e) {
        this.impl.error(msg, e);
        if (this.consoleLog != null) {
            this.consoleLog.error(msg, e);
        }
    }

    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled() || this.consoleLog != null && this.consoleLog.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled() || this.consoleLog != null && this.consoleLog.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled() || this.consoleLog != null && this.consoleLog.isInfoEnabled();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String toString() {
        return S.toString(Log4J2Logger.class, (Object)this);
    }

    static {
        mux = new Object();
    }
}

