/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt.join;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRange;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRangeBounds;

public class RangeSource {
    private final H2TreeIndex idx;
    private Iterator<GridH2RowRangeBounds> boundsIter;
    private int curRangeId = -1;
    private final int segment;
    private final BPlusTree.TreeRowClosure<H2Row, H2Row> filter;
    private Iterator<H2Row> iter = Collections.emptyIterator();

    public RangeSource(H2TreeIndex idx, Iterable<GridH2RowRangeBounds> bounds, int segment, BPlusTree.TreeRowClosure<H2Row, H2Row> filter) {
        this.idx = idx;
        this.segment = segment;
        this.filter = filter;
        this.boundsIter = bounds.iterator();
    }

    public boolean hasMoreRows() {
        return this.boundsIter.hasNext() || this.iter.hasNext();
    }

    public GridH2RowRange next(int maxRows) {
        assert (maxRows > 0) : maxRows;
        do {
            if (this.iter.hasNext()) {
                ArrayList<GridH2RowMessage> rows = new ArrayList<GridH2RowMessage>();
                GridH2RowRange nextRange = new GridH2RowRange();
                nextRange.rangeId(this.curRangeId);
                nextRange.rows(rows);
                do {
                    rows.add(H2Utils.toRowMessage(this.iter.next()));
                } while (rows.size() < maxRows && this.iter.hasNext());
                if (this.iter.hasNext()) {
                    nextRange.setPartial();
                } else {
                    this.iter = Collections.emptyIterator();
                }
                return nextRange;
            }
            this.iter = Collections.emptyIterator();
            if (!this.boundsIter.hasNext()) {
                this.boundsIter = Collections.emptyIterator();
                return null;
            }
            GridH2RowRangeBounds bounds = this.boundsIter.next();
            this.curRangeId = bounds.rangeId();
            this.iter = this.idx.findForSegment(bounds, this.segment, this.filter);
        } while (this.iter.hasNext());
        GridH2RowRange emptyRange = new GridH2RowRange();
        emptyRange.rangeId(this.curRangeId);
        return emptyRange;
    }
}

