/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.CacheException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceBlockList;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceResultPage;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceSourceKey;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceTable;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class ReduceIndex
extends BaseIndex {
    private static final int MAX_FETCH_SIZE = IgniteSystemProperties.getInteger((String)"IGNITE_SQL_MERGE_TABLE_MAX_SIZE", (int)10000);
    private static final int PREFETCH_SIZE = IgniteSystemProperties.getInteger((String)"IGNITE_SQL_MERGE_TABLE_PREFETCH_SIZE", (int)1024);
    private static final AtomicReferenceFieldUpdater<ReduceIndex, ConcurrentMap> LAST_PAGES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ReduceIndex.class, ConcurrentMap.class, "lastPages");
    protected final Comparator<SearchRow> firstRowCmp = new Comparator<SearchRow>(){

        @Override
        public int compare(SearchRow rowInList, SearchRow searchRow) {
            int res = ReduceIndex.this.compareRows(rowInList, searchRow);
            return res == 0 ? 1 : res;
        }
    };
    protected final Comparator<SearchRow> lastRowCmp = new Comparator<SearchRow>(){

        @Override
        public int compare(SearchRow rowInList, SearchRow searchRow) {
            int res = ReduceIndex.this.compareRows(rowInList, searchRow);
            return res == 0 ? -1 : res;
        }
    };
    private Set<UUID> sources;
    private int pageSize;
    private final ReduceBlockList<Row> fetched;
    private Row lastEvictedRow;
    private final GridKernalContext ctx;
    private volatile ConcurrentMap<ReduceSourceKey, Integer> lastPages;

    protected ReduceIndex(GridKernalContext ctx, ReduceTable tbl, String name, IndexType type, IndexColumn[] cols) {
        this(ctx);
        this.initBaseIndex((Table)tbl, 0, name, cols, type);
    }

    protected ReduceIndex(GridKernalContext ctx) {
        this.ctx = ctx;
        this.fetched = new ReduceBlockList(PREFETCH_SIZE);
    }

    public Set<UUID> sources() {
        return this.sources;
    }

    private void checkSourceNodesAlive() {
        for (UUID nodeId : this.sources()) {
            if (this.ctx.discovery().alive(nodeId)) continue;
            this.fail(nodeId, null);
            return;
        }
    }

    public boolean hasSource(UUID nodeId) {
        return this.sources.contains(nodeId);
    }

    public long getRowCount(Session ses) {
        Cursor c = this.find(ses, null, null);
        long cnt = 0L;
        while (c.next()) {
            ++cnt;
        }
        return cnt;
    }

    public long getRowCountApproximation() {
        return 10000L;
    }

    public void setSources(Collection<ClusterNode> nodes, int segmentsCnt) {
        assert (this.sources == null);
        this.sources = new HashSet<UUID>();
        for (ClusterNode node : nodes) {
            if (this.sources.add(node.id())) continue;
            throw new IllegalStateException();
        }
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private ReduceResultPage takeNextPage(Pollable<ReduceResultPage> queue) {
        ReduceResultPage page;
        while (true) {
            try {
                page = queue.poll(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new CacheException("Query execution was interrupted.", (Throwable)e);
            }
            if (page != null) break;
            this.checkSourceNodesAlive();
        }
        return page;
    }

    protected final Iterator<Value[]> pollNextIterator(Pollable<ReduceResultPage> queue, Iterator<Value[]> iter) {
        if (!iter.hasNext()) {
            ReduceResultPage page = this.takeNextPage(queue);
            if (!page.isLast()) {
                page.fetchNextPage();
            }
            iter = page.rows();
            assert (iter.hasNext() || page.isDummyLast() || page.isFail());
        }
        return iter;
    }

    public void fail(CacheException e) {
        for (UUID nodeId : this.sources) {
            this.fail(nodeId, e);
        }
    }

    public void fail(UUID nodeId, final CacheException e) {
        if (nodeId == null) {
            nodeId = (UUID)F.first(this.sources);
        }
        this.addPage0(new ReduceResultPage(null, nodeId, null){

            @Override
            public boolean isFail() {
                return true;
            }

            @Override
            public void fetchNextPage() {
                if (e != null) {
                    throw e;
                }
                super.fetchNextPage();
            }
        });
    }

    private void initLastPages(UUID nodeId, GridQueryNextPageResponse res) {
        int lastPage;
        int allRows = res.allRows();
        if (allRows < 0 || res.page() != 0) {
            return;
        }
        ConcurrentMap<ReduceSourceKey, Integer> lp = this.lastPages;
        if (lp == null && !LAST_PAGES_UPDATER.compareAndSet(this, null, lp = new ConcurrentHashMap<ReduceSourceKey, Integer>())) {
            lp = this.lastPages;
        }
        assert (this.pageSize > 0) : this.pageSize;
        int n = lastPage = allRows == 0 ? 0 : (allRows - 1) / this.pageSize;
        assert (lastPage >= 0) : lastPage;
        if (lp.put(new ReduceSourceKey(nodeId, res.segmentId()), lastPage) != null) {
            throw new IllegalStateException();
        }
    }

    private void markLastPage(ReduceResultPage page) {
        GridQueryNextPageResponse res = page.response();
        if (!res.last()) {
            UUID nodeId = page.source();
            this.initLastPages(nodeId, res);
            ConcurrentMap<ReduceSourceKey, Integer> lp = this.lastPages;
            if (lp == null) {
                return;
            }
            Integer lastPage = (Integer)lp.get(new ReduceSourceKey(nodeId, res.segmentId()));
            if (lastPage == null) {
                return;
            }
            if (lastPage.intValue() != res.page()) {
                assert (lastPage > res.page());
                return;
            }
        }
        page.setLast(true);
    }

    public final void addPage(ReduceResultPage page) {
        this.markLastPage(page);
        this.addPage0(page);
    }

    protected final ReduceResultPage createDummyLastPage(ReduceResultPage lastPage) {
        assert (!lastPage.isDummyLast());
        return new ReduceResultPage(this.ctx, lastPage.source(), null).setLast(true);
    }

    protected abstract void addPage0(ReduceResultPage var1);

    public final Cursor find(Session ses, SearchRow first, SearchRow last) {
        this.checkBounds(this.lastEvictedRow, first, last);
        if (this.fetchedAll()) {
            return this.findAllFetched(this.fetched, first, last);
        }
        return this.findInStream(first, last);
    }

    public abstract boolean fetchedAll();

    protected void checkBounds(Row lastEvictedRow, SearchRow first, SearchRow last) {
        if (lastEvictedRow != null) {
            throw new IgniteException("Fetched result set was too large.");
        }
    }

    protected abstract Cursor findInStream(@Nullable SearchRow var1, @Nullable SearchRow var2);

    protected abstract Cursor findAllFetched(List<Row> var1, @Nullable SearchRow var2, @Nullable SearchRow var3);

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void close(Session ses) {
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public void remove(Session ses) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException((String)"findFirstOrLast");
    }

    public boolean needRebuild() {
        return false;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    protected static int binarySearchRow(List<Row> rows, SearchRow searchRow, Comparator<SearchRow> cmp, boolean checkLast) {
        int res;
        assert (!rows.isEmpty());
        if (checkLast) {
            res = cmp.compare((SearchRow)ReduceIndex.last(rows), searchRow);
            assert (res != 0);
            if (res < 0) {
                return rows.size();
            }
        }
        res = Collections.binarySearch(rows, searchRow, cmp);
        assert (res < 0) : res;
        return -res - 1;
    }

    private void onBlockEvict(List<Row> evictedBlock) {
        assert (evictedBlock.size() == PREFETCH_SIZE);
        this.lastEvictedRow = Objects.requireNonNull(ReduceIndex.last(evictedBlock));
    }

    public static <Z> Z last(List<Z> l) {
        return l.get(l.size() - 1);
    }

    static {
        if (!U.isPow2((int)PREFETCH_SIZE)) {
            throw new IllegalArgumentException("IGNITE_SQL_MERGE_TABLE_PREFETCH_SIZE (" + PREFETCH_SIZE + ") must be positive and a power of 2.");
        }
        if (PREFETCH_SIZE >= MAX_FETCH_SIZE) {
            throw new IllegalArgumentException("IGNITE_SQL_MERGE_TABLE_PREFETCH_SIZE (" + PREFETCH_SIZE + ") must be less than " + "IGNITE_SQL_MERGE_TABLE_MAX_SIZE" + " (" + MAX_FETCH_SIZE + ").");
        }
    }

    protected static interface Pollable<E> {
        public E poll(long var1, TimeUnit var3) throws InterruptedException;
    }

    protected class FetchingCursor
    implements Cursor {
        Iterator<Row> stream;
        List<Row> rows;
        int cur;
        SearchRow first;
        SearchRow last;
        int lastFound = Integer.MAX_VALUE;

        public FetchingCursor(SearchRow first, SearchRow last, Iterator<Row> stream) {
            assert (stream != null);
            this.rows = ReduceIndex.this.fetched;
            this.stream = stream;
            this.first = first;
            this.last = last;
            if (this.haveBounds() && !this.rows.isEmpty()) {
                this.cur = this.findBounds();
            }
            --this.cur;
        }

        private boolean haveBounds() {
            return this.first != null || this.last != null;
        }

        private int findBounds() {
            assert (!this.rows.isEmpty()) : "rows";
            int firstFound = this.cur;
            if (this.first != null) {
                firstFound = ReduceIndex.binarySearchRow(this.rows, this.first, ReduceIndex.this.firstRowCmp, true);
                assert (firstFound >= this.cur && firstFound <= this.rows.size()) : "firstFound";
                if (firstFound == this.rows.size()) {
                    return firstFound;
                }
                this.first = null;
            }
            if (this.last != null) {
                assert (this.lastFound == Integer.MAX_VALUE) : "lastFound";
                int lastFound0 = ReduceIndex.binarySearchRow(this.rows, this.last, ReduceIndex.this.lastRowCmp, true);
                if (lastFound0 != this.rows.size()) {
                    this.lastFound = lastFound0;
                }
            }
            return firstFound;
        }

        private void fetchRows() {
            do {
                this.rows = ReduceIndex.this.fetched.lastBlock();
                this.cur = this.rows.size();
                while (this.stream.hasNext()) {
                    ReduceIndex.this.fetched.add(Objects.requireNonNull(this.stream.next()));
                    if (ReduceIndex.this.fetched.size() == MAX_FETCH_SIZE) {
                        ReduceIndex.this.onBlockEvict(ReduceIndex.this.fetched.evictFirstBlock());
                        assert (ReduceIndex.this.fetched.size() < MAX_FETCH_SIZE);
                    }
                    if (!this.haveBounds()) break;
                    if (ReduceIndex.this.fetched.lastBlock() == this.rows) continue;
                    assert (ReduceIndex.this.fetched.lastBlock().isEmpty());
                    break;
                }
                if (this.cur == this.rows.size()) {
                    this.cur = Integer.MAX_VALUE;
                    break;
                }
                if (!this.haveBounds()) break;
                this.cur = this.findBounds();
            } while (this.cur == this.rows.size());
        }

        public boolean next() {
            if (++this.cur == this.rows.size()) {
                this.fetchRows();
            }
            return this.cur < this.lastFound;
        }

        public Row get() {
            return this.rows.get(this.cur);
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean previous() {
            throw DbException.getUnsupportedException((String)"previous");
        }
    }
}

