/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextKey;
import org.jetbrains.annotations.Nullable;

public class QueryContextRegistry {
    private final ThreadLocal<QueryContext> locCtx = new ThreadLocal();
    private final ConcurrentMap<QueryContextKey, QueryContext> sharedCtxs = new ConcurrentHashMap<QueryContextKey, QueryContext>();

    @Nullable
    public QueryContext getThreadLocal() {
        return this.locCtx.get();
    }

    public void setThreadLocal(QueryContext x) {
        assert (this.locCtx.get() == null);
        this.locCtx.set(x);
    }

    public void clearThreadLocal() {
        this.locCtx.remove();
    }

    @Nullable
    public QueryContext getShared(UUID nodeId, long qryId, int segmentId) {
        return (QueryContext)this.sharedCtxs.get(new QueryContextKey(nodeId, qryId, segmentId));
    }

    public void setShared(UUID nodeId, long qryId, QueryContext ctx) {
        assert (ctx.distributedJoinContext() != null);
        QueryContextKey key = new QueryContextKey(nodeId, qryId, ctx.segment());
        QueryContext oldCtx = this.sharedCtxs.putIfAbsent(key, ctx);
        assert (oldCtx == null);
    }

    public boolean clearShared(UUID nodeId, long qryId) {
        boolean res = false;
        for (QueryContextKey key : this.sharedCtxs.keySet()) {
            if (!key.nodeId().equals(nodeId) || key.queryId() != qryId) continue;
            res |= this.doClear(key, false);
        }
        return res;
    }

    public void clearSharedOnLocalNodeStop() {
        for (QueryContextKey key : this.sharedCtxs.keySet()) {
            this.doClear(key, true);
        }
    }

    public void clearSharedOnRemoteNodeStop(UUID nodeId) {
        for (QueryContextKey key : this.sharedCtxs.keySet()) {
            if (!key.nodeId().equals(nodeId)) continue;
            this.doClear(key, false);
        }
    }

    private boolean doClear(QueryContextKey key, boolean nodeStop) {
        QueryContext ctx = (QueryContext)this.sharedCtxs.remove(key);
        if (ctx == null) {
            return false;
        }
        ctx.clearContext(nodeStop);
        return true;
    }
}

