/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class InlineIndexHelper {
    public static final int CANT_BE_COMPARE = -2;
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final ThreadLocal<GridTuple<List<InlineIndexHelper>>> CUR_HELPER = ThreadLocal.withInitial(GridTuple::new);
    public static final List<Integer> AVAILABLE_TYPES = Arrays.asList(1, 2, 3, 4, 5, 8, 7, 10, 9, 11, 20, 13, 21, 14, 12, 19);
    private final String colName;
    private final int type;
    private final int colIdx;
    private final int sortType;
    private final short size;
    private final boolean compareBinaryUnsigned;
    private final boolean compareStringsOptimized;

    public InlineIndexHelper(String colName, int type, int colIdx, int sortType, CompareMode compareMode) {
        this.colName = colName;
        this.type = type;
        this.colIdx = colIdx;
        this.sortType = sortType;
        this.compareBinaryUnsigned = compareMode.isBinaryUnsigned();
        this.compareStringsOptimized = "OFF".equals(compareMode.getName());
        switch (type) {
            case 1: 
            case 2: {
                this.size = 1;
                break;
            }
            case 3: {
                this.size = (short)2;
                break;
            }
            case 4: {
                this.size = (short)4;
                break;
            }
            case 5: {
                this.size = (short)8;
                break;
            }
            case 8: {
                this.size = (short)4;
                break;
            }
            case 7: {
                this.size = (short)8;
                break;
            }
            case 10: {
                this.size = (short)8;
                break;
            }
            case 9: {
                this.size = (short)8;
                break;
            }
            case 11: {
                this.size = (short)16;
                break;
            }
            case 20: {
                this.size = (short)16;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                this.size = (short)-1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("no get operation for fast index type " + type);
            }
        }
    }

    public String colName() {
        return this.colName;
    }

    public int type() {
        return this.type;
    }

    public int columnIndex() {
        return this.colIdx;
    }

    public int sortType() {
        return this.sortType;
    }

    public static List<InlineIndexHelper> getCurrentInlineIndexes() {
        return (List)CUR_HELPER.get().get();
    }

    public static void setCurrentInlineIndexes(List<InlineIndexHelper> inlineIdxs) {
        CUR_HELPER.get().set(inlineIdxs);
    }

    public static void clearCurrentInlineIndexes() {
        CUR_HELPER.get().set(null);
    }

    public short size() {
        return this.size;
    }

    public int fullSize(long pageAddr, int off) {
        byte type = PageUtils.getByte((long)pageAddr, (int)off);
        if (type == 0) {
            return 1;
        }
        if (this.size > 0) {
            return this.size + 1;
        }
        return PageUtils.getShort((long)pageAddr, (int)(off + 1)) + 3;
    }

    public Value get(long pageAddr, int off, int maxSize) {
        if (this.size > 0 && this.size + 1 > maxSize) {
            return null;
        }
        if (maxSize < 1) {
            return null;
        }
        byte type = PageUtils.getByte((long)pageAddr, (int)off);
        if (type == -1) {
            return null;
        }
        if (type == 0) {
            return ValueNull.INSTANCE;
        }
        if (this.type != type) {
            throw new UnsupportedOperationException("invalid fast index type " + type);
        }
        switch (this.type) {
            case 1: {
                return ValueBoolean.get((PageUtils.getByte((long)pageAddr, (int)(off + 1)) != 0 ? 1 : 0) != 0);
            }
            case 2: {
                return ValueByte.get((byte)PageUtils.getByte((long)pageAddr, (int)(off + 1)));
            }
            case 3: {
                return ValueShort.get((short)PageUtils.getShort((long)pageAddr, (int)(off + 1)));
            }
            case 4: {
                return ValueInt.get((int)PageUtils.getInt((long)pageAddr, (int)(off + 1)));
            }
            case 5: {
                return ValueLong.get((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)));
            }
            case 8: {
                return ValueFloat.get((float)Float.intBitsToFloat(PageUtils.getInt((long)pageAddr, (int)(off + 1))));
            }
            case 7: {
                return ValueDouble.get((double)Double.longBitsToDouble(PageUtils.getLong((long)pageAddr, (int)(off + 1))));
            }
            case 9: {
                return ValueTime.fromNanos((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)));
            }
            case 10: {
                return ValueDate.fromDateValue((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)));
            }
            case 11: {
                return ValueTimestamp.fromDateValueAndNanos((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)), (long)PageUtils.getLong((long)pageAddr, (int)(off + 9)));
            }
            case 20: {
                return ValueUuid.get((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)), (long)PageUtils.getLong((long)pageAddr, (int)(off + 9)));
            }
            case 13: {
                return ValueString.get((String)new String(InlineIndexHelper.readBytes(pageAddr, off), CHARSET));
            }
            case 21: {
                return ValueStringFixed.get((String)new String(InlineIndexHelper.readBytes(pageAddr, off), CHARSET));
            }
            case 14: {
                return ValueStringIgnoreCase.get((String)new String(InlineIndexHelper.readBytes(pageAddr, off), CHARSET));
            }
            case 12: {
                return ValueBytes.get((byte[])InlineIndexHelper.readBytes(pageAddr, off));
            }
            case 19: {
                return ValueJavaObject.getNoCopy(null, (byte[])InlineIndexHelper.readBytes(pageAddr, off), null);
            }
        }
        throw new UnsupportedOperationException("no get operation for fast index type " + type);
    }

    private static byte[] readBytes(long pageAddr, int off) {
        int size = PageUtils.getShort((long)pageAddr, (int)(off + 1)) & Short.MAX_VALUE;
        return PageUtils.getBytes((long)pageAddr, (int)(off + 3), (int)size);
    }

    protected boolean isValueFull(long pageAddr, int off) {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                return (PageUtils.getShort((long)pageAddr, (int)(off + 1)) & 0x8000) == 0;
            }
        }
        throw new UnsupportedOperationException("no get operation for fast index type " + this.type);
    }

    public int compare(long pageAddr, int off, int maxSize, Value v, Comparator<Value> comp) {
        int c = this.tryCompareOptimized(pageAddr, off, maxSize, v);
        if (c != Integer.MIN_VALUE) {
            return c;
        }
        Value v1 = this.get(pageAddr, off, maxSize);
        if (v1 == null) {
            return -2;
        }
        c = Integer.signum(comp.compare(v1, v));
        if (this.size > 0) {
            return InlineIndexHelper.fixSort(c, this.sortType());
        }
        if (this.isValueFull(pageAddr, off) || this.canRelyOnCompare(c, v1, v)) {
            return InlineIndexHelper.fixSort(c, this.sortType());
        }
        return -2;
    }

    private int tryCompareOptimized(long pageAddr, int off, int maxSize, Value v) {
        int type;
        if (this.size > 0 && this.size + 1 > maxSize || maxSize < 1 || (type = PageUtils.getByte((long)pageAddr, (int)off)) == -1) {
            return -2;
        }
        if (type == 0) {
            return Integer.MIN_VALUE;
        }
        if (v == ValueNull.INSTANCE) {
            return InlineIndexHelper.fixSort(1, this.sortType());
        }
        if (this.type != type) {
            throw new UnsupportedOperationException("Invalid fast index type: " + type);
        }
        type = Value.getHigherOrder((int)type, (int)v.getType());
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return this.compareAsPrimitive(pageAddr, off, v, type);
            }
            case 9: 
            case 10: 
            case 11: {
                return this.compareAsDateTime(pageAddr, off, v, type);
            }
            case 13: 
            case 14: 
            case 21: {
                if (!this.compareStringsOptimized) break;
                return this.compareAsString(pageAddr, off, v, type == 14);
            }
            case 20: {
                return this.compareAsUUID(pageAddr, off, v, type);
            }
            case 12: 
            case 19: {
                return this.compareAsBytes(pageAddr, off, v);
            }
        }
        return Integer.MIN_VALUE;
    }

    private int compareAsUUID(long pageAddr, int off, Value v, int type) {
        if (PageUtils.getByte((long)pageAddr, (int)off) == type) {
            assert (type == 20);
            ValueUuid uuid = (ValueUuid)v.convertTo(20);
            long long1 = PageUtils.getLong((long)pageAddr, (int)(off + 1));
            int c = Long.compare(long1, uuid.getHigh());
            if (c != 0) {
                return InlineIndexHelper.fixSort(c, this.sortType());
            }
            long1 = PageUtils.getLong((long)pageAddr, (int)(off + 9));
            c = Long.compare(long1, uuid.getLow());
            return InlineIndexHelper.fixSort(c, this.sortType());
        }
        return Integer.MIN_VALUE;
    }

    private int compareAsDateTime(long pageAddr, int off, Value v, int type) {
        if (PageUtils.getByte((long)pageAddr, (int)off) == type) {
            switch (type) {
                case 9: {
                    long nanos1 = PageUtils.getLong((long)pageAddr, (int)(off + 1));
                    long nanos2 = ((ValueTime)v.convertTo(type)).getNanos();
                    return InlineIndexHelper.fixSort(Long.signum(nanos1 - nanos2), this.sortType());
                }
                case 10: {
                    long date1 = PageUtils.getLong((long)pageAddr, (int)(off + 1));
                    long date2 = ((ValueDate)v.convertTo(type)).getDateValue();
                    return InlineIndexHelper.fixSort(Long.signum(date1 - date2), this.sortType());
                }
                case 11: {
                    ValueTimestamp v0 = (ValueTimestamp)v.convertTo(type);
                    long date1 = PageUtils.getLong((long)pageAddr, (int)(off + 1));
                    long date2 = v0.getDateValue();
                    int c = Long.signum(date1 - date2);
                    if (c == 0) {
                        long nanos1 = PageUtils.getLong((long)pageAddr, (int)(off + 9));
                        long nanos2 = v0.getTimeNanos();
                        c = Long.signum(nanos1 - nanos2);
                    }
                    return InlineIndexHelper.fixSort(c, this.sortType());
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    private int compareAsPrimitive(long pageAddr, int off, Value v, int type) {
        if (PageUtils.getByte((long)pageAddr, (int)off) == type) {
            switch (type) {
                case 1: {
                    boolean bool1 = PageUtils.getByte((long)pageAddr, (int)(off + 1)) != 0;
                    boolean bool2 = v.getBoolean();
                    return InlineIndexHelper.fixSort(Boolean.compare(bool1, bool2), this.sortType());
                }
                case 2: {
                    byte byte1 = PageUtils.getByte((long)pageAddr, (int)(off + 1));
                    byte byte2 = v.getByte();
                    return InlineIndexHelper.fixSort(Integer.signum(byte1 - byte2), this.sortType());
                }
                case 3: {
                    short short1 = PageUtils.getShort((long)pageAddr, (int)(off + 1));
                    short short2 = v.getShort();
                    return InlineIndexHelper.fixSort(Integer.signum(short1 - short2), this.sortType());
                }
                case 4: {
                    int int1 = PageUtils.getInt((long)pageAddr, (int)(off + 1));
                    int int2 = v.getInt();
                    return InlineIndexHelper.fixSort(Integer.compare(int1, int2), this.sortType());
                }
                case 5: {
                    long long1 = PageUtils.getLong((long)pageAddr, (int)(off + 1));
                    long long2 = v.getLong();
                    return InlineIndexHelper.fixSort(Long.compare(long1, long2), this.sortType());
                }
                case 8: {
                    float float1 = Float.intBitsToFloat(PageUtils.getInt((long)pageAddr, (int)(off + 1)));
                    float float2 = v.getFloat();
                    return InlineIndexHelper.fixSort(Float.compare(float1, float2), this.sortType());
                }
                case 7: {
                    double double1 = Double.longBitsToDouble(PageUtils.getLong((long)pageAddr, (int)(off + 1)));
                    double double2 = v.getDouble();
                    return InlineIndexHelper.fixSort(Double.compare(double1, double2), this.sortType());
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    private int compareAsBytes(long pageAddr, int off, Value v) {
        int i;
        int len1;
        byte[] bytes = v.getBytesNoCopy();
        long addr = pageAddr + (long)off + 1L;
        if (this.size > 0) {
            len1 = this.size;
        } else {
            len1 = PageUtils.getShort((long)pageAddr, (int)(off + 1)) & Short.MAX_VALUE;
            addr += 2L;
        }
        int len2 = bytes.length;
        int len = Math.min(len1, len2);
        if (this.compareBinaryUnsigned) {
            for (i = 0; i < len; ++i) {
                int b2;
                int b1 = GridUnsafe.getByte((long)(addr + (long)i)) & 0xFF;
                if (b1 == (b2 = bytes[i] & 0xFF)) continue;
                return InlineIndexHelper.fixSort(Integer.signum(b1 - b2), this.sortType());
            }
        } else {
            for (i = 0; i < len; ++i) {
                byte b2;
                byte b1 = GridUnsafe.getByte((long)(addr + (long)i));
                if (b1 == (b2 = bytes[i])) continue;
                return InlineIndexHelper.fixSort(Integer.signum(b1 - b2), this.sortType());
            }
        }
        int res = Integer.signum(len1 - len2);
        if (this.isValueFull(pageAddr, off)) {
            return InlineIndexHelper.fixSort(res, this.sortType());
        }
        if (res >= 0) {
            return InlineIndexHelper.fixSort(1, this.sortType());
        }
        return -2;
    }

    private int compareAsString(long pageAddr, int off, Value v, boolean ignoreCase) {
        int res;
        char v2;
        char v1;
        int c;
        String s = v.getString();
        int len1 = PageUtils.getShort((long)pageAddr, (int)(off + 1)) & Short.MAX_VALUE;
        int len2 = s.length();
        int cntr1 = 0;
        int cntr2 = 0;
        long addr = pageAddr + (long)off + 3L;
        while (cntr1 < len1 && cntr2 < len2 && (c = GridUnsafe.getByte((long)addr) & 0xFF) <= 127) {
            ++cntr1;
            ++addr;
            v1 = (char)c;
            v2 = s.charAt(cntr2++);
            if (ignoreCase) {
                v1 = Character.toUpperCase(v1);
                v2 = Character.toUpperCase(v2);
            }
            if (v1 == v2) continue;
            return InlineIndexHelper.fixSort(Integer.signum(v1 - v2), this.sortType());
        }
        block7: while (cntr1 < len1 && cntr2 < len2) {
            c = GridUnsafe.getByte((long)addr++) & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++cntr1;
                    v1 = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    int c2;
                    if ((cntr1 += 2) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    if (((c2 = GridUnsafe.getByte((long)addr++) & 0xFF) & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 2));
                    }
                    c &= 0x1F;
                    c = c << 6 | c2 & 0x3F;
                    v1 = (char)c;
                    break;
                }
                case 14: {
                    if ((cntr1 += 3) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    int c2 = GridUnsafe.getByte((long)addr++) & 0xFF;
                    int c3 = GridUnsafe.getByte((long)addr++) & 0xFF;
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 3));
                    }
                    c &= 0xF;
                    c = c << 6 | c2 & 0x3F;
                    c = c << 6 | c3 & 0x3F;
                    v1 = (char)c;
                    break;
                }
                case 15: {
                    if ((cntr1 += 4) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    int c2 = GridUnsafe.getByte((long)addr++) & 0xFF;
                    int c3 = GridUnsafe.getByte((long)addr++) & 0xFF;
                    int c4 = GridUnsafe.getByte((long)addr++) & 0xFF;
                    if ((c & 0xF8) != 240 || (c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 4));
                    }
                    c &= 7;
                    c = c << 6 | c2 & 0x3F;
                    c = c << 6 | c3 & 0x3F;
                    c = c << 6 | c4 & 0x3F;
                    v1 = (char)(55296 + ((c -= 65536) >> 10 & 0x7FF));
                    if (v1 != (v2 = s.charAt(cntr2++))) {
                        return InlineIndexHelper.fixSort(Integer.signum(v1 - v2), this.sortType());
                    }
                    if (cntr2 == len2) {
                        return InlineIndexHelper.fixSort(1, this.sortType());
                    }
                    v1 = (char)(56320 + (c & 0x3FF));
                    if (v1 == (v2 = s.charAt(cntr2++))) continue block7;
                    return InlineIndexHelper.fixSort(Integer.signum(v1 - v2), this.sortType());
                }
                default: {
                    throw new IllegalStateException("Malformed input around byte: " + cntr1);
                }
            }
            v2 = s.charAt(cntr2++);
            if (ignoreCase) {
                v1 = Character.toUpperCase(v1);
                v2 = Character.toUpperCase(v2);
            }
            if (v1 == v2) continue;
            return InlineIndexHelper.fixSort(Integer.signum(v1 - v2), this.sortType());
        }
        int n = cntr1 == len1 && cntr2 == len2 ? 0 : (res = cntr1 == len1 ? -1 : 1);
        if (this.isValueFull(pageAddr, off)) {
            return InlineIndexHelper.fixSort(res, this.sortType());
        }
        if (res >= 0) {
            return InlineIndexHelper.fixSort(1, this.sortType());
        }
        return -2;
    }

    public int inlineSizeOf(Value val) {
        if (val.getType() == 0) {
            return 1;
        }
        if (val.getType() != this.type) {
            throw new UnsupportedOperationException("value type doesn't match");
        }
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: {
                return this.size + 1;
            }
            case 13: 
            case 14: 
            case 21: {
                return val.getString().getBytes(CHARSET).length + 3;
            }
            case 12: 
            case 19: {
                return val.getBytes().length + 3;
            }
        }
        throw new UnsupportedOperationException("no get operation for fast index type " + this.type);
    }

    public int put(long pageAddr, int off, Value val, int maxSize) {
        if (this.size > 0 && this.size + 1 > maxSize) {
            return 0;
        }
        if (this.size < 0 && maxSize < 4) {
            PageUtils.putByte((long)pageAddr, (int)off, (byte)-1);
            return 0;
        }
        if (val.getType() == 0) {
            PageUtils.putByte((long)pageAddr, (int)off, (byte)0);
            return 1;
        }
        if (val.getType() != this.type) {
            throw new UnsupportedOperationException("value type doesn't match");
        }
        switch (this.type) {
            case 1: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putByte((long)pageAddr, (int)(off + 1), (byte)((byte)(val.getBoolean() ? 1 : 0)));
                return this.size + 1;
            }
            case 2: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putByte((long)pageAddr, (int)(off + 1), (byte)val.getByte());
                return this.size + 1;
            }
            case 3: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)val.getShort());
                return this.size + 1;
            }
            case 4: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putInt((long)pageAddr, (int)(off + 1), (int)val.getInt());
                return this.size + 1;
            }
            case 5: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)val.getLong());
                return this.size + 1;
            }
            case 8: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putInt((long)pageAddr, (int)(off + 1), (int)Float.floatToIntBits(val.getFloat()));
                return this.size + 1;
            }
            case 7: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)Double.doubleToLongBits(val.getDouble()));
                return this.size + 1;
            }
            case 9: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueTime)val).getNanos());
                return this.size + 1;
            }
            case 10: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueDate)val).getDateValue());
                return this.size + 1;
            }
            case 11: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueTimestamp)val).getDateValue());
                PageUtils.putLong((long)pageAddr, (int)(off + 9), (long)((ValueTimestamp)val).getTimeNanos());
                return this.size + 1;
            }
            case 20: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueUuid)val).getHigh());
                PageUtils.putLong((long)pageAddr, (int)(off + 9), (long)((ValueUuid)val).getLow());
                return this.size + 1;
            }
            case 13: 
            case 14: 
            case 21: {
                byte[] s = val.getString().getBytes(CHARSET);
                short size = s.length + 3 <= maxSize ? (short)s.length : (short)((s = InlineIndexHelper.trimUTF8(s, maxSize - 3)) == null ? 0 : s.length | 0x8000);
                if (s == null) {
                    PageUtils.putByte((long)pageAddr, (int)off, (byte)-1);
                    return 0;
                }
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)size);
                PageUtils.putBytes((long)pageAddr, (int)(off + 3), (byte[])s);
                return s.length + 3;
            }
            case 12: 
            case 19: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                byte[] bytes = val.getBytes();
                if (bytes.length + 3 <= maxSize) {
                    short size = (short)bytes.length;
                    PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)size);
                    PageUtils.putBytes((long)pageAddr, (int)(off + 3), (byte[])bytes);
                    return size + 3;
                }
                short size = (short)(maxSize - 3 | 0x8000);
                PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)size);
                PageUtils.putBytes((long)pageAddr, (int)(off + 3), (byte[])Arrays.copyOfRange(bytes, 0, maxSize - 3));
                return maxSize;
            }
        }
        throw new UnsupportedOperationException("no get operation for fast index type " + this.type);
    }

    public static byte[] trimUTF8(byte[] bytes, int limit) {
        if (bytes.length <= limit) {
            return bytes;
        }
        for (int i = limit; i > 0; --i) {
            if ((bytes[i] & 0xC0) == 128) continue;
            byte[] res = new byte[i];
            System.arraycopy(bytes, 0, res, 0, i);
            return res;
        }
        return null;
    }

    protected boolean canRelyOnCompare(int c, Value shortVal, Value v2) {
        switch (this.type) {
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                int l2;
                int l1;
                if (shortVal.getType() == 0 || v2.getType() == 0) {
                    return true;
                }
                if (c == 0 && shortVal.getType() != 0 && v2.getType() != 0) {
                    return false;
                }
                if (this.type == 12 || this.type == 19) {
                    l1 = shortVal.getBytes().length;
                    l2 = v2.getBytes().length;
                } else {
                    l1 = shortVal.getString().length();
                    l2 = v2.getString().length();
                }
                return c >= 0 || l1 > l2;
            }
        }
        return true;
    }

    public static int fixSort(int c, int sortType) {
        return sortType == 0 ? c : -c;
    }

    public static String nameTypeBycode(int typeCode) {
        switch (typeCode) {
            case -1: {
                return "UNKNOWN";
            }
            case 0: {
                return "NULL";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "BYTE";
            }
            case 3: {
                return "SHORT";
            }
            case 4: {
                return "INT";
            }
            case 5: {
                return "LONG";
            }
            case 6: {
                return "DECIMAL";
            }
            case 7: {
                return "DOUBLE";
            }
            case 8: {
                return "FLOAT";
            }
            case 9: {
                return "TIME";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "TIMESTAMP";
            }
            case 12: {
                return "BYTES";
            }
            case 13: {
                return "STRING";
            }
            case 14: {
                return "STRING_IGNORECASE";
            }
            case 15: {
                return "BLOB";
            }
            case 16: {
                return "CLOB";
            }
            case 17: {
                return "ARRAY";
            }
            case 18: {
                return "RESULT_SET";
            }
            case 19: {
                return "JAVA_OBJECT";
            }
            case 20: {
                return "UUID";
            }
            case 21: {
                return "STRING_FIXED";
            }
            case 22: {
                return "GEOMETRY";
            }
            case 24: {
                return "TIMESTAMP_TZ";
            }
            case 25: {
                return "ENUM";
            }
        }
        return "UNKNOWN type " + typeCode;
    }
}

