/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.engine.Session;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;

public abstract class H2TreeIndexBase
extends GridH2IndexBase {
    public static final int IGNITE_MAX_INDEX_PAYLOAD_SIZE_DEFAULT = 10;

    protected H2TreeIndexBase(GridH2Table tbl) {
        super(tbl);
    }

    public abstract int inlineSize();

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = this.getCostRangeIndex(masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    protected List<InlineIndexHelper> getAvailableInlineColumns(IndexColumn[] cols) {
        ArrayList<InlineIndexHelper> res = new ArrayList<InlineIndexHelper>();
        for (IndexColumn col : cols) {
            if (!InlineIndexHelper.AVAILABLE_TYPES.contains(col.column.getType())) {
                this.warnCantBeInlined(col);
                break;
            }
            InlineIndexHelper idx = new InlineIndexHelper(col.columnName, col.column.getType(), col.column.getColumnId(), col.sortType, this.table.getCompareMode());
            res.add(idx);
        }
        return res;
    }

    protected void warnCantBeInlined(IndexColumn col) {
    }

    protected int computeInlineSize(List<InlineIndexHelper> inlineIdxs, int cfgInlineSize, CacheConfiguration<?, ?> cacheConf) {
        int propSize;
        int confSize = cacheConf.getSqlIndexMaxInlineSize();
        int n = propSize = confSize == -1 ? IgniteSystemProperties.getInteger((String)"IGNITE_MAX_INDEX_PAYLOAD_SIZE", (int)10) : confSize;
        if (cfgInlineSize == 0) {
            return 0;
        }
        if (F.isEmpty(inlineIdxs)) {
            return 0;
        }
        if (cfgInlineSize == -1) {
            if (propSize == 0) {
                return 0;
            }
            int size = 0;
            for (InlineIndexHelper idxHelper : inlineIdxs) {
                if (idxHelper.size() <= 0) {
                    size = propSize;
                    break;
                }
                size += idxHelper.size() + 1;
            }
            return Math.min(2048, size);
        }
        return Math.min(2048, cfgInlineSize);
    }

    public boolean canGetFirstOrLast() {
        return true;
    }
}

