/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public class H2TreeClientIndex
extends H2TreeIndexBase {
    private final int inlineSize;

    public H2TreeClientIndex(GridH2Table table, String name, boolean pk, List<IndexColumn> colsList, int inlineSize) {
        super(table);
        this.table = table;
        IndexColumn[] cols = colsList.toArray(new IndexColumn[0]);
        this.inlineSize = this.calculateInlineSize(cols, inlineSize, table.cacheInfo().config());
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)table);
        this.initBaseIndex((Table)table, 0, name, cols, pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
    }

    @Override
    public int inlineSize() {
        return this.inlineSize;
    }

    private int calculateInlineSize(IndexColumn[] cols, int inlineSize, CacheConfiguration<?, ?> cacheConf) {
        List<InlineIndexHelper> inlineCols = this.getAvailableInlineColumns(cols);
        return this.computeInlineSize(inlineCols, inlineSize, cacheConf);
    }

    @Override
    public void refreshColumnIds() {
    }

    @Override
    public long totalRowCount(IndexingQueryCacheFilter partsFilter) {
        throw H2TreeClientIndex.unsupported();
    }

    @Override
    public int segmentsCount() {
        throw H2TreeClientIndex.unsupported();
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        throw H2TreeClientIndex.unsupported();
    }

    @Override
    public H2CacheRow put(H2CacheRow row) {
        throw H2TreeClientIndex.unsupported();
    }

    @Override
    public boolean putx(H2CacheRow row) {
        throw H2TreeClientIndex.unsupported();
    }

    @Override
    public boolean removex(SearchRow row) {
        throw H2TreeClientIndex.unsupported();
    }

    public long getRowCount(Session ses) {
        throw H2TreeClientIndex.unsupported();
    }

    public Cursor findFirstOrLast(Session session, boolean first) {
        throw H2TreeClientIndex.unsupported();
    }

    private static IgniteException unsupported() {
        return new IgniteSQLException("Shouldn't be invoked on non-affinity node.");
    }
}

