/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.query.h2.H2ResultSetIterator;
import org.apache.ignite.internal.processors.query.h2.ThreadLocalObjectPool;

public class H2FieldsIterator
extends H2ResultSetIterator<List<?>> {
    private static final long serialVersionUID = 0L;
    private transient MvccQueryTracker mvccTracker;
    private final ThreadLocalObjectPool.Reusable detachedConn;

    public H2FieldsIterator(ResultSet data, MvccQueryTracker mvccTracker, ThreadLocalObjectPool.Reusable detachedConn) throws IgniteCheckedException {
        super(data);
        assert (detachedConn != null);
        this.mvccTracker = mvccTracker;
        this.detachedConn = detachedConn;
    }

    @Override
    protected List<?> createRow() {
        ArrayList res = new ArrayList(this.row.length);
        Collections.addAll(res, this.row);
        return res;
    }

    @Override
    public void onClose() throws IgniteCheckedException {
        try {
            super.onClose();
        }
        finally {
            this.detachedConn.recycle();
            if (this.mvccTracker != null) {
                this.mvccTracker.onDone();
            }
        }
    }
}

