/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ScanIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.table.TableType;

public class GridMergeTable
extends TableBase {
    private ArrayList<Index> idxs;

    public GridMergeTable(CreateTableData data) {
        super(data);
    }

    public void indexes(ArrayList<Index> idxs) {
        assert (!F.isEmpty(idxs));
        this.idxs = idxs;
    }

    public GridMergeIndex getMergeIndex() {
        return (GridMergeIndex)this.idxs.get(this.idxs.size() - 1);
    }

    public static GridH2ScanIndex<GridMergeIndex> createScanIndex(GridMergeIndex idx) {
        return new ScanIndex(idx);
    }

    public boolean lock(Session session, boolean exclusive, boolean force) {
        return false;
    }

    public void close(Session ses) {
    }

    public void unlock(Session s) {
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException((String)"addIndex");
    }

    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException((String)"removeRow");
    }

    public void truncate(Session session) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException((String)"addRow");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"alter");
    }

    public TableType getTableType() {
        return TableType.EXTERNAL_TABLE_ENGINE;
    }

    public Index getScanIndex(Session session) {
        return this.idxs.get(0);
    }

    public Index getUniqueIndex() {
        return null;
    }

    public ArrayList<Index> getIndexes() {
        return this.idxs;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(Session ses) {
        return this.getScanIndex(ses).getRowCount(ses);
    }

    public long getRowCountApproximation() {
        return this.getScanIndex(null).getRowCountApproximation();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    private static class ScanIndex
    extends GridH2ScanIndex<GridMergeIndex> {
        public ScanIndex(GridMergeIndex delegate) {
            super(delegate);
        }

        public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
            long rows = this.getRowCountApproximation();
            return this.getCostRangeIndex(masks, rows, filters, filter, sortOrder, true, allColumnsSet);
        }
    }
}

