/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.query.h2.opt.DistributedJoinMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2CollocationModel;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridH2QueryContext {
    private static final ThreadLocal<GridH2QueryContext> qctx = new ThreadLocal();
    private static final ConcurrentMap<Key, GridH2QueryContext> qctxs = new ConcurrentHashMap8();
    private final Key key;
    private volatile boolean cleared;
    private List<GridReservable> reservations;
    private Map<Integer, Object> streams;
    private Map<SourceKey, Object> sources;
    private int batchLookupIdGen;
    private IndexingQueryFilter filter;
    private AffinityTopologyVersion topVer;
    private Map<UUID, int[]> partsMap;
    private UUID[] partsNodes;
    private DistributedJoinMode distributedJoinMode;
    private int pageSize;
    private GridH2CollocationModel qryCollocationMdl;

    public GridH2QueryContext(UUID locNodeId, UUID nodeId, long qryId, GridH2QueryType type) {
        assert (type != GridH2QueryType.MAP);
        this.key = new Key(locNodeId, nodeId, qryId, 0, type);
    }

    public GridH2QueryContext(UUID locNodeId, UUID nodeId, long qryId, int segmentId, GridH2QueryType type) {
        assert (segmentId == 0 || type == GridH2QueryType.MAP);
        this.key = new Key(locNodeId, nodeId, qryId, segmentId, type);
    }

    public GridH2QueryType type() {
        return this.key.type;
    }

    public UUID originNodeId() {
        return this.key.nodeId;
    }

    public long queryId() {
        return this.key.qryId;
    }

    public GridH2CollocationModel queryCollocationModel() {
        return this.qryCollocationMdl;
    }

    public void queryCollocationModel(GridH2CollocationModel qryCollocationMdl) {
        this.qryCollocationMdl = qryCollocationMdl;
    }

    public GridH2QueryContext distributedJoinMode(DistributedJoinMode distributedJoinMode) {
        this.distributedJoinMode = distributedJoinMode;
        return this;
    }

    public DistributedJoinMode distributedJoinMode() {
        return this.distributedJoinMode;
    }

    public GridH2QueryContext reservations(List<GridReservable> reservations) {
        this.reservations = reservations;
        return this;
    }

    public GridH2QueryContext topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
        return this;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public GridH2QueryContext partitionsMap(Map<UUID, int[]> partsMap) {
        this.partsMap = partsMap;
        return this;
    }

    public Map<UUID, int[]> partitionsMap() {
        return this.partsMap;
    }

    public UUID nodeForPartition(int p, GridCacheContext<?, ?> cctx) {
        UUID[] nodeIds = this.partsNodes;
        if (nodeIds == null) {
            assert (this.partsMap != null);
            nodeIds = new UUID[cctx.affinity().partitions()];
            for (Map.Entry<UUID, int[]> e : this.partsMap.entrySet()) {
                UUID nodeId = e.getKey();
                int[] nodeParts = e.getValue();
                assert (nodeId != null);
                assert (!F.isEmpty((int[])nodeParts));
                for (int part : nodeParts) {
                    assert (nodeIds[part] == null);
                    nodeIds[part] = nodeId;
                }
            }
            this.partsNodes = nodeIds;
        }
        return nodeIds[p];
    }

    public int segment() {
        return this.key.segmentId;
    }

    public synchronized void putStreams(int batchLookupId, Object streams) {
        if (this.streams == null) {
            if (streams == null) {
                return;
            }
            this.streams = new HashMap<Integer, Object>();
        }
        if (streams == null) {
            this.streams.remove(batchLookupId);
        } else {
            this.streams.put(batchLookupId, streams);
        }
    }

    public synchronized <T> T getStreams(int batchLookupId) {
        if (this.streams == null) {
            return null;
        }
        return (T)this.streams.get(batchLookupId);
    }

    public synchronized void putSource(UUID ownerId, int segmentId, int batchLookupId, Object src) {
        SourceKey srcKey = new SourceKey(ownerId, segmentId, batchLookupId);
        if (src != null) {
            if (this.sources == null) {
                this.sources = new HashMap<SourceKey, Object>();
            }
            this.sources.put(srcKey, src);
        } else if (this.sources != null) {
            this.sources.remove(srcKey);
        }
    }

    public synchronized <T> T getSource(UUID ownerId, int segmentId, int batchLookupId) {
        if (this.sources == null) {
            return null;
        }
        return (T)this.sources.get(new SourceKey(ownerId, segmentId, batchLookupId));
    }

    public int nextBatchLookupId() {
        return ++this.batchLookupIdGen;
    }

    public static void set(GridH2QueryContext x) {
        assert (qctx.get() == null);
        if (x.key.type == GridH2QueryType.MAP && x.distributedJoinMode() != DistributedJoinMode.OFF && qctxs.putIfAbsent(x.key, x) != null) {
            throw new IllegalStateException("Query context is already set.");
        }
        qctx.set(x);
    }

    public static void clearThreadLocal() {
        GridH2QueryContext x = qctx.get();
        assert (x != null);
        qctx.remove();
    }

    public static boolean clear(UUID locNodeId, UUID nodeId, long qryId, GridH2QueryType type) {
        boolean res = false;
        for (Key key : qctxs.keySet()) {
            if (!key.locNodeId.equals(locNodeId) || !key.nodeId.equals(nodeId) || key.qryId != qryId || key.type != type) continue;
            res |= GridH2QueryContext.doClear(new Key(locNodeId, nodeId, qryId, key.segmentId, type), false);
        }
        return res;
    }

    private static boolean doClear(Key key, boolean nodeStop) {
        assert (key.type == GridH2QueryType.MAP) : Key.access$100(key);
        GridH2QueryContext x = (GridH2QueryContext)qctxs.remove(key);
        if (x == null) {
            return false;
        }
        assert (x.key.equals(key));
        x.clearContext(nodeStop);
        return true;
    }

    public void clearContext(boolean nodeStop) {
        this.cleared = true;
        List<GridReservable> r = this.reservations;
        if (!nodeStop && !F.isEmpty(r)) {
            for (int i = 0; i < r.size(); ++i) {
                r.get(i).release();
            }
        }
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public static void clearAfterDeadNode(UUID locNodeId, UUID nodeId) {
        for (Key key : qctxs.keySet()) {
            if (!key.locNodeId.equals(locNodeId) || !key.nodeId.equals(nodeId)) continue;
            GridH2QueryContext.doClear(key, false);
        }
    }

    public static void clearLocalNodeStop(UUID locNodeId) {
        for (Key key : qctxs.keySet()) {
            if (!key.locNodeId.equals(locNodeId)) continue;
            GridH2QueryContext.doClear(key, true);
        }
    }

    @Nullable
    public static GridH2QueryContext get() {
        return qctx.get();
    }

    @Nullable
    public static GridH2QueryContext get(UUID locNodeId, UUID nodeId, long qryId, int segmentId, GridH2QueryType type) {
        return (GridH2QueryContext)qctxs.get(new Key(locNodeId, nodeId, qryId, segmentId, type));
    }

    public IndexingQueryFilter filter() {
        return this.filter;
    }

    public GridH2QueryContext filter(IndexingQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public GridH2QueryContext pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public String toString() {
        return S.toString(GridH2QueryContext.class, (Object)this);
    }

    private static final class SourceKey {
        UUID ownerId;
        int segmentId;
        int batchLookupId;

        SourceKey(UUID ownerId, int segmentId, int batchLookupId) {
            this.ownerId = ownerId;
            this.segmentId = segmentId;
            this.batchLookupId = batchLookupId;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SourceKey)) {
                return false;
            }
            SourceKey srcKey = (SourceKey)o;
            return this.batchLookupId == srcKey.batchLookupId && this.segmentId == srcKey.segmentId && this.ownerId.equals(srcKey.ownerId);
        }

        public int hashCode() {
            int hash = this.ownerId.hashCode();
            hash = 31 * hash + this.segmentId;
            return 31 * hash + this.batchLookupId;
        }
    }

    private static class Key {
        private final UUID locNodeId;
        private final UUID nodeId;
        private final long qryId;
        private final int segmentId;
        private final GridH2QueryType type;

        private Key(UUID locNodeId, UUID nodeId, long qryId, int segmentId, GridH2QueryType type) {
            assert (locNodeId != null);
            assert (nodeId != null);
            assert (type != null);
            this.locNodeId = locNodeId;
            this.nodeId = nodeId;
            this.qryId = qryId;
            this.segmentId = segmentId;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.qryId == key.qryId && this.nodeId.equals(key.nodeId) && this.type == key.type && this.locNodeId.equals(key.locNodeId);
        }

        public int hashCode() {
            int res = this.locNodeId.hashCode();
            res = 31 * res + this.nodeId.hashCode();
            res = 31 * res + (int)(this.qryId ^ this.qryId >>> 32);
            res = 31 * res + this.type.hashCode();
            res = 31 * res + this.segmentId;
            return res;
        }

        public String toString() {
            return S.toString(Key.class, (Object)this);
        }
    }
}

