/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;

public class H2RowFactory {
    private final GridCacheContext<?, ?> cctx;
    private final GridH2RowDescriptor rowDesc;

    public H2RowFactory(GridH2RowDescriptor rowDesc, GridCacheContext<?, ?> cctx) {
        this.rowDesc = rowDesc;
        this.cctx = cctx;
    }

    public GridH2Row getRow(long link) throws IgniteCheckedException {
        GridH2Row row;
        CacheDataRowAdapter rowBuilder = new CacheDataRowAdapter(link);
        rowBuilder.initFromLink(this.cctx.group(), CacheDataRowAdapter.RowData.FULL);
        try {
            row = this.rowDesc.createRow((CacheDataRow)rowBuilder);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        assert (row.version() != null);
        return row;
    }
}

